/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.component.vertx.VertxHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.Message;

public class VertxConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxConsumer.class);
    private final VertxEndpoint endpoint;
    private Handler<? extends Message> handler = new Handler<Message>(){

        @Override
        public void handle(Message event) {
            VertxConsumer.this.onEventBusEvent(event);
        }
    };

    public VertxConsumer(VertxEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void onEventBusEvent(final Message event) {
        LOG.debug("onEvent {}", (Object)event);
        final boolean reply = event.replyAddress() != null;
        final Exchange exchange = this.endpoint.createExchange(reply ? ExchangePattern.InOut : ExchangePattern.InOnly);
        exchange.getIn().setBody(event.body());
        try {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    Object body;
                    if (reply && (body = VertxHelper.getVertxBody(exchange)) != null) {
                        LOG.debug("Sending reply to: {} with body: {}", (Object)event.replyAddress(), body);
                        event.reply(body);
                    }
                }
            });
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing Vertx event: " + event, exchange, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering EventBus handler on address {}", (Object)this.endpoint.getAddress());
        }
        this.endpoint.getEventBus().registerHandler(this.endpoint.getAddress(), this.handler);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unregistering EventBus handler on address {}", (Object)this.endpoint.getAddress());
        }
        this.endpoint.getEventBus().unregisterHandler(this.endpoint.getAddress(), this.handler);
        super.doStop();
    }
}

