/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.component.vertx.VertxHelper;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;

public class VertxProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxProducer.class);

    public VertxProducer(VertxEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public VertxEndpoint getEndpoint() {
        return (VertxEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        EventBus eventBus = this.getEndpoint().getEventBus();
        String address = this.getEndpoint().getAddress();
        boolean reply = ExchangeHelper.isOutCapable((Exchange)exchange);
        boolean pubSub = this.getEndpoint().isPubSub();
        Object body = VertxHelper.getVertxBody(exchange);
        if (body != null) {
            if (reply) {
                LOG.debug("Sending to: {} with body: {}", (Object)address, body);
                eventBus.send(address, body, new CamelReplyHandler(exchange, callback));
                return false;
            }
            if (pubSub) {
                LOG.debug("Publishing to: {} with body: {}", (Object)address, body);
                eventBus.publish(address, body);
            } else {
                LOG.debug("Sending to: {} with body: {}", (Object)address, body);
                eventBus.send(address, body);
            }
            callback.done(true);
            return true;
        }
        exchange.setException((Throwable)new InvalidPayloadRuntimeException(exchange, String.class));
        callback.done(true);
        return true;
    }

    private static final class CamelReplyHandler
    implements Handler<org.vertx.java.core.eventbus.Message> {
        private final Exchange exchange;
        private final AsyncCallback callback;

        private CamelReplyHandler(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(org.vertx.java.core.eventbus.Message event) {
            try {
                MessageHelper.copyHeaders((Message)this.exchange.getIn(), (Message)this.exchange.getOut(), (boolean)false);
                this.exchange.getOut().setBody(event.body());
            }
            finally {
                this.callback.done(false);
            }
        }
    }
}

