/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.datagram.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;

final class DatagramChannelFutureListener<T>
implements ChannelFutureListener {
    private final Handler<AsyncResult<T>> handler;
    private final T result;
    private final DefaultContext context;
    private final VertxInternal vertx;

    DatagramChannelFutureListener(T result, Handler<AsyncResult<T>> handler, VertxInternal vertx, DefaultContext context) {
        this.handler = handler;
        this.result = result;
        this.context = context;
        this.vertx = vertx;
    }

    @Override
    public void operationComplete(final ChannelFuture future) throws Exception {
        Channel ch = future.channel();
        if (this.context.isOnCorrectWorker(ch.eventLoop())) {
            try {
                this.vertx.setContext(this.context);
                this.notifyHandler(future);
            }
            catch (Throwable t) {
                this.context.reportException(t);
            }
        } else {
            this.context.execute(new Runnable(){

                @Override
                public void run() {
                    DatagramChannelFutureListener.this.notifyHandler(future);
                }
            });
        }
    }

    private void notifyHandler(ChannelFuture future) {
        if (future.isSuccess()) {
            this.handler.handle(new DefaultFutureResult<T>(this.result));
        } else {
            this.handler.handle(new DefaultFutureResult<Throwable>(future.cause()));
        }
    }
}

