/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.TimeoutException;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpHeaders;
import org.vertx.java.core.http.impl.AssembledFullHttpRequest;
import org.vertx.java.core.http.impl.AssembledHttpRequest;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpClientResponse;
import org.vertx.java.core.http.impl.HttpHeadersAdapter;
import org.vertx.java.core.impl.DefaultContext;

public class DefaultHttpClientRequest
implements HttpClientRequest {
    private final DefaultHttpClient client;
    private final HttpRequest request;
    private final Handler<HttpClientResponse> respHandler;
    private Handler<Void> continueHandler;
    private final DefaultContext context;
    private final boolean raw;
    private boolean chunked;
    private ClientConnection conn;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean headWritten;
    private boolean completed;
    private ByteBuf pendingChunks;
    private int pendingMaxSize = -1;
    private boolean connecting;
    private boolean writeHead;
    private long written;
    private long currentTimeoutTimerId = -1L;
    private MultiMap headers;
    private boolean exceptionOccurred;
    private long lastDataReceived;

    DefaultHttpClientRequest(DefaultHttpClient client, String method, String uri, Handler<HttpClientResponse> respHandler, DefaultContext context) {
        this(client, method, uri, respHandler, context, false);
    }

    private DefaultHttpClientRequest(DefaultHttpClient client, String method, String uri, Handler<HttpClientResponse> respHandler, DefaultContext context, boolean raw) {
        this.client = client;
        this.request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf(method), uri, false);
        this.chunked = false;
        this.respHandler = respHandler;
        this.context = context;
        this.raw = raw;
    }

    @Override
    public DefaultHttpClientRequest setChunked(boolean chunked) {
        this.check();
        if (this.written > 0L) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        this.chunked = chunked;
        return this;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HttpHeadersAdapter(this.request.headers());
        }
        return this.headers;
    }

    @Override
    public HttpClientRequest putHeader(String name, String value) {
        this.check();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.check();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public DefaultHttpClientRequest write(Buffer chunk) {
        this.check();
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf, false);
    }

    @Override
    public DefaultHttpClientRequest write(String chunk) {
        this.check();
        return this.write(new Buffer(chunk));
    }

    @Override
    public DefaultHttpClientRequest write(String chunk, String enc) {
        this.check();
        return this.write(new Buffer(chunk, enc));
    }

    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.check();
        if (this.conn != null) {
            this.conn.doSetWriteQueueMaxSize(maxSize);
        } else {
            this.pendingMaxSize = maxSize;
        }
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        this.check();
        if (this.conn != null) {
            return this.conn.doWriteQueueFull();
        }
        return false;
    }

    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.check();
        this.drainHandler = handler;
        if (this.conn != null) {
            this.conn.handleInterestedOpsChanged();
        }
        return this;
    }

    @Override
    public HttpClientRequest exceptionHandler(final Handler<Throwable> handler) {
        this.check();
        this.exceptionHandler = new Handler<Throwable>(){

            @Override
            public void handle(Throwable event) {
                DefaultHttpClientRequest.this.cancelOutstandingTimeoutTimer();
                handler.handle(event);
            }
        };
        return this;
    }

    @Override
    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.check();
        this.continueHandler = handler;
        return this;
    }

    @Override
    public DefaultHttpClientRequest sendHead() {
        this.check();
        if (this.conn != null) {
            if (!this.headWritten) {
                this.writeHead();
            }
        } else {
            this.connect();
            this.writeHead = true;
        }
        return this;
    }

    @Override
    public void end(String chunk) {
        this.end(new Buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(new Buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        this.check();
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
        }
        this.write(chunk.getByteBuf(), true);
    }

    @Override
    public void end() {
        this.check();
        this.write(Unpooled.EMPTY_BUFFER, true);
    }

    @Override
    public HttpClientRequest setTimeout(final long timeoutMs) {
        this.cancelOutstandingTimeoutTimer();
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, new Handler<Long>(){

            @Override
            public void handle(Long event) {
                DefaultHttpClientRequest.this.handleTimeout(timeoutMs);
            }
        });
        return this;
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.check();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.check();
        this.headers().set(name, values);
        return this;
    }

    void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Throwable t) {
        this.cancelOutstandingTimeoutTimer();
        this.exceptionOccurred = true;
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        } else {
            this.context.reportException(t);
        }
    }

    boolean hasExceptionOccurred() {
        return this.exceptionOccurred;
    }

    void handleResponse(DefaultHttpClientResponse resp) {
        if (!this.exceptionOccurred) {
            this.cancelOutstandingTimeoutTimer();
            try {
                if (resp.statusCode() == 100) {
                    if (this.continueHandler != null) {
                        this.continueHandler.handle(null);
                    }
                } else {
                    this.respHandler.handle(resp);
                }
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    private void cancelOutstandingTimeoutTimer() {
        if (this.currentTimeoutTimerId != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
        }
    }

    private void handleTimeout(long timeoutMs) {
        if (this.lastDataReceived == 0L) {
            this.timeout(timeoutMs);
        } else {
            long now = System.currentTimeMillis();
            long timeSinceLastData = now - this.lastDataReceived;
            if (timeSinceLastData >= timeoutMs) {
                this.timeout(timeoutMs);
            } else {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
            }
        }
    }

    private void timeout(long timeoutMs) {
        this.handleException(new TimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded"));
    }

    private void connect() {
        if (!this.connecting) {
            this.client.getConnection(new Handler<ClientConnection>(){

                @Override
                public void handle(ClientConnection conn) {
                    if (DefaultHttpClientRequest.this.exceptionOccurred) {
                        conn.close();
                    } else if (!conn.isClosed()) {
                        DefaultHttpClientRequest.this.connected(conn);
                    } else {
                        DefaultHttpClientRequest.this.connecting = false;
                        DefaultHttpClientRequest.this.connect();
                    }
                }
            }, this.exceptionHandler, this.context);
            this.connecting = true;
        }
    }

    private synchronized void connected(ClientConnection conn) {
        conn.setCurrentRequest(this);
        this.conn = conn;
        if (this.pendingMaxSize != -1) {
            conn.doSetWriteQueueMaxSize(this.pendingMaxSize);
        }
        if (this.pendingChunks != null) {
            ByteBuf pending = this.pendingChunks;
            this.pendingChunks = null;
            if (this.completed) {
                this.writeHeadWithContent(pending, true);
                conn.endRequest();
            } else {
                this.writeHeadWithContent(pending, false);
            }
        } else if (this.completed) {
            this.writeHeadWithContent(Unpooled.EMPTY_BUFFER, true);
            conn.endRequest();
        } else if (this.writeHead) {
            this.writeHead();
        }
    }

    private boolean contentLengthSet() {
        if (this.headers != null) {
            return this.request.headers().contains(HttpHeaders.CONTENT_LENGTH);
        }
        return false;
    }

    private void writeHead() {
        this.prepareHeaders();
        this.conn.write(this.request);
        this.headWritten = true;
    }

    private void writeHeadWithContent(ByteBuf buf, boolean end) {
        this.prepareHeaders();
        if (end) {
            this.conn.write(new AssembledFullHttpRequest(this.request, buf));
        } else {
            this.conn.write(new AssembledHttpRequest(this.request, buf));
        }
        this.headWritten = true;
    }

    private void prepareHeaders() {
        io.netty.handler.codec.http.HttpHeaders headers = this.request.headers();
        headers.remove(HttpHeaders.TRANSFER_ENCODING);
        if (!this.raw) {
            if (!headers.contains(HttpHeaders.HOST)) {
                this.request.headers().set(HttpHeaders.HOST, (Object)this.conn.hostHeader);
            }
            if (this.chunked) {
                io.netty.handler.codec.http.HttpHeaders.setTransferEncodingChunked(this.request);
            }
        }
        if (this.client.getTryUseCompression() && this.request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            this.request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
        }
    }

    private synchronized DefaultHttpClientRequest write(ByteBuf buff, boolean end) {
        int readableBytes = buff.readableBytes();
        if (readableBytes == 0 && !end) {
            return this;
        }
        if (end) {
            this.completed = true;
        }
        this.written += (long)buff.readableBytes();
        if (!(end || this.raw || this.chunked || this.contentLengthSet())) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        if (this.conn == null) {
            if (this.pendingChunks == null) {
                this.pendingChunks = buff;
            } else {
                CompositeByteBuf pending;
                if (this.pendingChunks instanceof CompositeByteBuf) {
                    pending = (CompositeByteBuf)this.pendingChunks;
                } else {
                    pending = Unpooled.compositeBuffer();
                    pending.addComponent(this.pendingChunks).writerIndex(this.pendingChunks.writerIndex());
                    this.pendingChunks = pending;
                }
                pending.addComponent(buff).writerIndex(pending.writerIndex() + buff.writerIndex());
            }
            this.connect();
        } else {
            if (!this.headWritten) {
                this.writeHeadWithContent(buff, end);
            } else if (end) {
                this.writeEndChunk(buff);
            } else {
                this.sendChunk(buff);
            }
            if (end) {
                this.conn.endRequest();
            }
        }
        return this;
    }

    private void sendChunk(ByteBuf buff) {
        this.conn.write(new DefaultHttpContent(buff));
    }

    private void writeEndChunk(ByteBuf buf) {
        if (buf.isReadable()) {
            this.conn.write(new DefaultLastHttpContent(buf, false));
        } else {
            this.conn.write(LastHttpContent.EMPTY_LAST_CONTENT);
        }
    }

    private void check() {
        this.checkComplete();
    }

    private void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }
}

