/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpHeaders;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.DefaultHttpClientRequest;
import org.vertx.java.core.http.impl.HttpHeadersAdapter;
import org.vertx.java.core.net.NetSocket;

public class DefaultHttpClientResponse
implements HttpClientResponse {
    private final int statusCode;
    private final String statusMessage;
    private final DefaultHttpClientRequest request;
    private final Vertx vertx;
    private final ClientConnection conn;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private final HttpResponse response;
    private LastHttpContent trailer;
    private boolean paused;
    private Queue<Buffer> pausedChunks;
    private boolean hasPausedEnd;
    private LastHttpContent pausedTrailer;
    private NetSocket netSocket;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    DefaultHttpClientResponse(Vertx vertx, DefaultHttpClientRequest request, ClientConnection conn, HttpResponse response) {
        this.vertx = vertx;
        this.statusCode = response.getStatus().code();
        this.statusMessage = response.getStatus().reasonPhrase();
        this.request = request;
        this.conn = conn;
        this.response = response;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HttpHeadersAdapter(this.response.headers());
        }
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            this.trailers = new HttpHeadersAdapter(new DefaultHttpHeaders());
        }
        return this.trailers;
    }

    @Override
    public List<String> cookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<String>();
            this.cookies.addAll(this.response.headers().getAll(HttpHeaders.SET_COOKIE));
            if (this.trailer != null) {
                this.cookies.addAll(this.trailer.trailingHeaders().getAll(HttpHeaders.SET_COOKIE));
            }
        }
        return this.cookies;
    }

    @Override
    public HttpClientResponse dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
        return this;
    }

    @Override
    public HttpClientResponse endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public HttpClientResponse pause() {
        this.paused = true;
        this.conn.doPause();
        return this;
    }

    @Override
    public HttpClientResponse resume() {
        this.paused = false;
        this.doResume();
        this.conn.doResume();
        return this;
    }

    @Override
    public HttpClientResponse bodyHandler(final Handler<Buffer> bodyHandler) {
        final BodyHandler handler = new BodyHandler();
        this.dataHandler((Handler)handler);
        this.endHandler((Handler)new VoidHandler(){

            @Override
            public void handle() {
                handler.notifyHandler(bodyHandler);
            }
        });
        return this;
    }

    private void doResume() {
        if (this.pausedChunks != null) {
            Buffer chunk;
            while ((chunk = this.pausedChunks.poll()) != null) {
                final Buffer theChunk = chunk;
                this.vertx.runOnContext(new VoidHandler(){

                    @Override
                    protected void handle() {
                        DefaultHttpClientResponse.this.handleChunk(theChunk);
                    }
                });
            }
        }
        if (this.hasPausedEnd) {
            final LastHttpContent theTrailer = this.pausedTrailer;
            this.vertx.runOnContext(new VoidHandler(){

                @Override
                protected void handle() {
                    DefaultHttpClientResponse.this.handleEnd(theTrailer);
                }
            });
            this.hasPausedEnd = false;
            this.pausedTrailer = null;
        }
    }

    void handleChunk(Buffer data) {
        if (this.paused) {
            if (this.pausedChunks == null) {
                this.pausedChunks = new ArrayDeque<Buffer>();
            }
            this.pausedChunks.add(data);
        } else {
            this.request.dataReceived();
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        }
    }

    void handleEnd(LastHttpContent trailer) {
        if (this.paused) {
            this.hasPausedEnd = true;
            this.pausedTrailer = trailer;
        } else {
            this.trailer = trailer;
            this.trailers = new HttpHeadersAdapter(trailer.trailingHeaders());
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    void handleException(Throwable e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }

    @Override
    public NetSocket netSocket() {
        if (this.netSocket == null) {
            this.netSocket = this.conn.createNetSocket();
        }
        return this.netSocket;
    }

    private final class BodyHandler
    implements Handler<Buffer> {
        private Buffer body;

        private BodyHandler() {
        }

        @Override
        public void handle(Buffer event) {
            this.body().appendBuffer(event);
        }

        private Buffer body() {
            if (this.body == null) {
                this.body = new Buffer();
            }
            return this.body;
        }

        void notifyHandler(Handler<Buffer> bodyHandler) {
            bodyHandler.handle(this.body());
            this.body = null;
        }
    }
}

