/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.json;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonElement;
import org.vertx.java.core.json.impl.Base64;
import org.vertx.java.core.json.impl.Json;

public class JsonObject
extends JsonElement {
    protected Map<String, Object> map;

    public JsonObject(Map<String, Object> map) {
        this(map, true);
    }

    public JsonObject() {
        this.map = new LinkedHashMap<String, Object>();
    }

    protected JsonObject(Map<String, Object> map, boolean copy) {
        this.map = copy ? this.convertMap(map) : map;
    }

    public JsonObject(String jsonString) {
        this.map = (Map)Json.decodeValue(jsonString, Map.class);
    }

    public JsonObject putString(String fieldName, String value) {
        this.map.put(fieldName, value);
        return this;
    }

    public JsonObject putObject(String fieldName, JsonObject value) {
        this.map.put(fieldName, value == null ? null : value.map);
        return this;
    }

    public JsonObject putArray(String fieldName, JsonArray value) {
        this.map.put(fieldName, value == null ? null : value.list);
        return this;
    }

    public JsonObject putElement(String fieldName, JsonElement value) {
        if (value == null) {
            this.map.put(fieldName, null);
            return this;
        }
        if (value.isArray()) {
            return this.putArray(fieldName, value.asArray());
        }
        return this.putObject(fieldName, value.asObject());
    }

    public JsonObject putNumber(String fieldName, Number value) {
        this.map.put(fieldName, value);
        return this;
    }

    public JsonObject putBoolean(String fieldName, Boolean value) {
        this.map.put(fieldName, value);
        return this;
    }

    public JsonObject putBinary(String fieldName, byte[] binary) {
        this.map.put(fieldName, binary == null ? null : Base64.encodeBytes(binary));
        return this;
    }

    public JsonObject putValue(String fieldName, Object value) {
        if (value == null) {
            this.putObject(fieldName, null);
        } else if (value instanceof JsonObject) {
            this.putObject(fieldName, (JsonObject)value);
        } else if (value instanceof JsonArray) {
            this.putArray(fieldName, (JsonArray)value);
        } else if (value instanceof String) {
            this.putString(fieldName, (String)value);
        } else if (value instanceof Number) {
            this.putNumber(fieldName, (Number)value);
        } else if (value instanceof Boolean) {
            this.putBoolean(fieldName, (Boolean)value);
        } else if (value instanceof byte[]) {
            this.putBinary(fieldName, (byte[])value);
        } else {
            throw new VertxException("Cannot put objects of class " + value.getClass() + " in JsonObject");
        }
        return this;
    }

    public String getString(String fieldName) {
        return (String)this.map.get(fieldName);
    }

    public JsonObject getObject(String fieldName) {
        Map m = (Map)this.map.get(fieldName);
        return m == null ? null : new JsonObject(m, false);
    }

    public JsonArray getArray(String fieldName) {
        List l = (List)this.map.get(fieldName);
        return l == null ? null : new JsonArray(l, false);
    }

    public JsonElement getElement(String fieldName) {
        Object element = this.map.get(fieldName);
        if (element == null) {
            return null;
        }
        if (element instanceof Map) {
            return this.getObject(fieldName);
        }
        if (element instanceof List) {
            return this.getArray(fieldName);
        }
        throw new ClassCastException();
    }

    public Number getNumber(String fieldName) {
        return (Number)this.map.get(fieldName);
    }

    public Long getLong(String fieldName) {
        Number num = (Number)this.map.get(fieldName);
        return num == null ? null : Long.valueOf(num.longValue());
    }

    public Integer getInteger(String fieldName) {
        Number num = (Number)this.map.get(fieldName);
        return num == null ? null : Integer.valueOf(num.intValue());
    }

    public Boolean getBoolean(String fieldName) {
        return (Boolean)this.map.get(fieldName);
    }

    public byte[] getBinary(String fieldName) {
        String encoded = (String)this.map.get(fieldName);
        return encoded == null ? null : Base64.decode(encoded);
    }

    public String getString(String fieldName, String def) {
        String str = this.getString(fieldName);
        return str == null ? def : str;
    }

    public JsonObject getObject(String fieldName, JsonObject def) {
        JsonObject obj = this.getObject(fieldName);
        return obj == null ? def : obj;
    }

    public JsonArray getArray(String fieldName, JsonArray def) {
        JsonArray arr = this.getArray(fieldName);
        return arr == null ? def : arr;
    }

    public JsonElement getElement(String fieldName, JsonElement def) {
        JsonElement elem = this.getElement(fieldName);
        return elem == null ? def : elem;
    }

    public boolean getBoolean(String fieldName, boolean def) {
        Boolean b = this.getBoolean(fieldName);
        return b == null ? def : b;
    }

    public Number getNumber(String fieldName, int def) {
        Number n = this.getNumber(fieldName);
        return n == null ? (Number)def : (Number)n;
    }

    public Long getLong(String fieldName, long def) {
        Number num = (Number)this.map.get(fieldName);
        return num == null ? def : num.longValue();
    }

    public Integer getInteger(String fieldName, int def) {
        Number num = (Number)this.map.get(fieldName);
        return num == null ? def : num.intValue();
    }

    public byte[] getBinary(String fieldName, byte[] def) {
        byte[] b = this.getBinary(fieldName);
        return b == null ? def : b;
    }

    public Set<String> getFieldNames() {
        return this.map.keySet();
    }

    public <T> T getValue(String fieldName) {
        return this.getField(fieldName);
    }

    public <T> T getField(String fieldName) {
        Object obj = this.map.get(fieldName);
        if (obj instanceof Map) {
            obj = new JsonObject((Map)obj, false);
        } else if (obj instanceof List) {
            obj = new JsonArray((List)obj, false);
        }
        return (T)obj;
    }

    public Object removeField(String fieldName) {
        return this.map.remove(fieldName);
    }

    public boolean containsField(String fieldName) {
        return this.map.containsKey(fieldName);
    }

    public int size() {
        return this.map.size();
    }

    public JsonObject mergeIn(JsonObject other) {
        this.map.putAll(other.map);
        return this;
    }

    public String encode() {
        return Json.encode(this.map);
    }

    public String encodePrettily() {
        return Json.encodePrettily(this.map);
    }

    public JsonObject copy() {
        return new JsonObject(this.map, true);
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        if (this.map.size() != that.map.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object val = entry.getValue();
            if (!(val == null ? that.map.get(entry.getKey()) != null : !this.equals(entry.getValue(), that.map.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public Map<String, Object> toMap() {
        return this.convertMap(this.map);
    }
}

