/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.EndpointCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VertxFactory;

public class VertxComponent
extends UriEndpointComponent
implements EndpointCompleter {
    private static final Logger LOG = LoggerFactory.getLogger(VertxComponent.class);
    private Vertx vertx;
    private String host;
    private int port;

    public VertxComponent() {
        super(VertxEndpoint.class);
    }

    public VertxComponent(CamelContext context) {
        super(context, VertxEndpoint.class);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        VertxEndpoint endpoint = new VertxEndpoint(uri, this, remaining);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public List<String> completeEndpointPath(ComponentConfiguration componentConfiguration, String text) {
        return null;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            if (this.host != null && this.host.length() > 0) {
                LOG.info("Creating Clustered Vertx {}:{}", (Object)this.host, (Object)this.port);
                this.vertx = VertxFactory.newVertx(this.port, this.host);
            } else if (this.host != null) {
                LOG.info("Creating Clustered Vertx {}", (Object)this.host);
                this.vertx = VertxFactory.newVertx(this.host);
            } else {
                LOG.info("Creating Non-Clustered Vertx");
                this.vertx = VertxFactory.newVertx();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.info("Stopping Vertx {}", (Object)this.vertx);
        this.vertx.stop();
    }
}

