/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2ServerRequestImpl;
import io.vertx.core.http.impl.Http2ServerResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;

public class Http2ServerConnection
extends Http2ConnectionBase {
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final Handler<HttpServerRequest> requestHandler;
    private final HttpServerMetrics metrics;
    private Long maxConcurrentStreams;
    private int concurrentStreams;
    private final ArrayDeque<Push> pendingPushes = new ArrayDeque(8);

    Http2ServerConnection(ContextInternal context, String serverOrigin, VertxHttp2ConnectionHandler connHandler, HttpServerOptions options, Handler<HttpServerRequest> requestHandler, HttpServerMetrics metrics) {
        super(context, connHandler);
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.requestHandler = requestHandler;
        this.metrics = metrics;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    private static boolean isMalformedRequest(Http2Headers headers) {
        if (headers.method() == null) {
            return true;
        }
        String method = headers.method().toString();
        if (method.equals("CONNECT") ? headers.scheme() != null || headers.path() != null || headers.authority() == null : headers.method() == null || headers.scheme() == null || headers.path() == null) {
            return true;
        }
        if (headers.authority() != null) {
            URI uri;
            try {
                uri = new URI(null, headers.authority().toString(), null, null, null);
            }
            catch (URISyntaxException e) {
                return true;
            }
            if (uri.getRawUserInfo() != null) {
                return true;
            }
        }
        return false;
    }

    private Http2ServerRequestImpl createRequest(int streamId, Http2Headers headers, boolean streamEnded) {
        Http2Stream stream = this.handler.connection().stream(streamId);
        String contentEncoding = this.options.isCompressionSupported() ? HttpUtils.determineContentEncoding(headers) : null;
        boolean writable = this.handler.encoder().flowController().isWritable(stream);
        return new Http2ServerRequestImpl(this, stream, this.metrics, this.serverOrigin, headers, contentEncoding, writable, streamEnded);
    }

    @Override
    public synchronized void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        VertxHttp2Stream stream = (VertxHttp2Stream)this.streams.get(streamId);
        if (stream == null) {
            if (Http2ServerConnection.isMalformedRequest(headers)) {
                this.handler.writeReset(streamId, Http2Error.PROTOCOL_ERROR.code());
                return;
            }
            Http2ServerRequestImpl req = this.createRequest(streamId, headers, endOfStream);
            req.priority(new StreamPriority().setDependency(streamDependency).setWeight(weight).setExclusive(exclusive));
            stream = req;
            CharSequence value = (CharSequence)headers.get(HttpHeaderNames.EXPECT);
            if (this.options.isHandle100ContinueAutomatically() && (value != null && HttpHeaderValues.CONTINUE.equals(value) || headers.contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE))) {
                req.response().writeContinue();
            }
            this.streams.put(streamId, req);
            this.context.executeFromIO(req, this.requestHandler);
        }
        if (endOfStream) {
            VertxHttp2Stream finalStream = stream;
            this.context.executeFromIO(v -> finalStream.onEnd());
        }
    }

    @Override
    public synchronized void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        this.onHeadersRead(ctx, streamId, headers, 0, (short)16, false, padding, endOfStream);
    }

    @Override
    public synchronized void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        Long v = settings.maxConcurrentStreams();
        if (v != null) {
            this.maxConcurrentStreams = v;
        }
        super.onSettingsRead(ctx, settings);
    }

    synchronized void sendPush(int streamId, String host, final HttpMethod method, MultiMap headers, final String path, final StreamPriority streamPriority, final Handler<AsyncResult<HttpServerResponse>> completionHandler) {
        final DefaultHttp2Headers headers_ = new DefaultHttp2Headers();
        if (method == HttpMethod.OTHER) {
            throw new IllegalArgumentException("Cannot push HttpMethod.OTHER");
        }
        headers_.method(method.name());
        headers_.path(path);
        headers_.scheme(this.isSsl() ? "https" : "http");
        if (host != null) {
            headers_.authority(host);
        }
        if (headers != null) {
            headers.forEach(header -> {
                Http2Headers cfr_ignored_0 = (Http2Headers)headers_.add(header.getKey(), header.getValue());
            });
        }
        this.handler.writePushPromise(streamId, headers_, new Handler<AsyncResult<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(AsyncResult<Integer> ar) {
                if (ar.succeeded()) {
                    Http2ServerConnection http2ServerConnection = Http2ServerConnection.this;
                    synchronized (http2ServerConnection) {
                        int promisedStreamId = ar.result();
                        String contentEncoding = HttpUtils.determineContentEncoding(headers_);
                        Http2Stream promisedStream = Http2ServerConnection.this.handler.connection().stream(promisedStreamId);
                        boolean writable = Http2ServerConnection.this.handler.encoder().flowController().isWritable(promisedStream);
                        Push push = new Push(promisedStream, contentEncoding, method, path, writable, completionHandler);
                        push.priority(streamPriority);
                        Http2ServerConnection.this.streams.put(promisedStreamId, push);
                        if (Http2ServerConnection.this.maxConcurrentStreams == null || (long)Http2ServerConnection.this.concurrentStreams < Http2ServerConnection.this.maxConcurrentStreams) {
                            Http2ServerConnection.this.concurrentStreams++;
                            Http2ServerConnection.this.context.executeFromIO(v -> push.complete());
                        } else {
                            Http2ServerConnection.this.pendingPushes.add(push);
                        }
                    }
                } else {
                    Http2ServerConnection.this.context.executeFromIO(v -> completionHandler.handle(Future.failedFuture(ar.cause())));
                }
            }
        });
    }

    @Override
    protected void updateSettings(Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        settingsUpdate.remove('\u0002');
        super.updateSettings(settingsUpdate, completionHandler);
    }

    private class Push
    extends VertxHttp2Stream<Http2ServerConnection> {
        private final HttpMethod method;
        private final String uri;
        private final String contentEncoding;
        private Http2ServerResponseImpl response;
        private final Future<HttpServerResponse> completionHandler;

        public Push(Http2Stream stream, String contentEncoding, HttpMethod method, String uri, boolean writable, Handler<AsyncResult<HttpServerResponse>> completionHandler) {
            super(Http2ServerConnection.this, stream, writable);
            this.method = method;
            this.uri = uri;
            this.contentEncoding = contentEncoding;
            this.completionHandler = Future.future().setHandler(completionHandler);
        }

        @Override
        void handleEnd(MultiMap trailers) {
        }

        @Override
        void handleData(Buffer buf) {
        }

        @Override
        void handlePriorityChange(StreamPriority streamPriority) {
        }

        @Override
        void handleInterestedOpsChanged() {
            if (this.response != null) {
                this.response.writabilityChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleReset(long errorCode) {
            Http2ServerResponseImpl response;
            Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
            synchronized (http2ServerConnection) {
                response = this.response;
            }
            if (response != null) {
                response.handleReset(errorCode);
            } else {
                this.completionHandler.fail(new StreamResetException(errorCode));
            }
        }

        @Override
        void handleException(Throwable cause) {
            if (this.response != null) {
                this.response.handleException(cause);
            }
        }

        @Override
        void handleClose() {
            if (Http2ServerConnection.this.pendingPushes.remove(this)) {
                this.completionHandler.fail("Push reset by client");
            } else {
                Http2ServerConnection.this.concurrentStreams--;
                while ((Http2ServerConnection.this.maxConcurrentStreams == null || (long)Http2ServerConnection.this.concurrentStreams < Http2ServerConnection.this.maxConcurrentStreams) && Http2ServerConnection.this.pendingPushes.size() > 0) {
                    Push push = (Push)Http2ServerConnection.this.pendingPushes.pop();
                    Http2ServerConnection.this.concurrentStreams++;
                    this.context.runOnContext(v -> push.complete());
                }
                this.response.handleClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            Http2ServerConnection http2ServerConnection = Http2ServerConnection.this;
            synchronized (http2ServerConnection) {
                this.response = new Http2ServerResponseImpl(Http2ServerConnection.this, this, this.method, true, this.contentEncoding, null);
                if (Metrics.METRICS_ENABLED && Http2ServerConnection.this.metrics != null) {
                    this.response.metric(Http2ServerConnection.this.metrics.responsePushed(((Http2ServerConnection)this.conn).metric(), this.method, this.uri, this.response));
                }
                this.completionHandler.complete(this.response);
            }
        }
    }
}

