/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.Http1xOrH2CHandler;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xUpgradeToH2CHandler;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpHandlers;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.VertxHttpRequestDecoder;
import io.vertx.core.http.impl.VertxHttpResponseEncoder;
import io.vertx.core.http.impl.WebSocketRequestHandler;
import io.vertx.core.http.impl.cgbystrom.FlashPolicyHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class HttpServerImpl
implements HttpServer,
Closeable,
MetricsProvider {
    static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> log.trace((Object)"Connection failure", (Throwable)t);
    private static final String FLASH_POLICY_HANDLER_PROP_NAME = "vertx.flashPolicyHandler";
    private static final boolean USE_FLASH_POLICY_HANDLER = Boolean.getBoolean("vertx.flashPolicyHandler");
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    private static final boolean DISABLE_WEBSOCKETS = Boolean.getBoolean("vertx.disableWebsockets");
    private static final String DISABLE_H2C_PROP_NAME = "vertx.disableH2c";
    private final boolean DISABLE_H2C = Boolean.getBoolean("vertx.disableH2c");
    private final HttpServerOptions options;
    private final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final ContextInternal creatingContext;
    private final Map<Channel, ConnectionBase> connectionMap = new ConcurrentHashMap<Channel, ConnectionBase>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<HttpHandlers> httpHandlerMgr = new HandlerManager(this.availableWorkers);
    private final HttpStreamHandler<ServerWebSocket> wsStream = new HttpStreamHandler();
    private final HttpStreamHandler<HttpServerRequest> requestStream = new HttpStreamHandler();
    private Handler<HttpConnection> connectionHandler;
    private final String subProtocols;
    private String serverOrigin;
    private ChannelGroup serverChannelGroup;
    private volatile boolean listening;
    private AsyncResolveConnectHelper bindFuture;
    private ServerID id;
    private HttpServerImpl actualServer;
    private volatile int actualPort;
    private ContextInternal listenContext;
    private HttpServerMetrics metrics;
    private boolean logEnabled;
    private Handler<Throwable> exceptionHandler;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        this.options = new HttpServerOptions(options);
        this.vertx = vertx;
        this.creatingContext = vertx.getContext();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use HttpServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.subProtocols = options.getWebsocketSubProtocols();
        this.logEnabled = options.getLogActivity();
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.requestStream.handler(handler);
        return this;
    }

    @Override
    public ReadStream<HttpServerRequest> requestStream() {
        return this.requestStream;
    }

    @Override
    public HttpServer websocketHandler(Handler<ServerWebSocket> handler) {
        this.websocketStream().handler(handler);
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestStream.handler();
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServer exceptionHandler(Handler<Throwable> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> websocketHandler() {
        return this.wsStream.handler();
    }

    @Override
    public ReadStream<ServerWebSocket> websocketStream() {
        return this.wsStream;
    }

    @Override
    public HttpServer listen() {
        return this.listen(this.options.getPort(), this.options.getHost(), null);
    }

    @Override
    public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public HttpServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public HttpServer listen(int port) {
        return this.listen(port, "0.0.0.0", null);
    }

    @Override
    public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    @Override
    public HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(SocketAddress.inetSocketAddress(port, host), listenHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpServer listen(SocketAddress address, Handler<AsyncResult<HttpServer>> listenHandler) {
        if (this.requestStream.handler() == null && this.wsStream.handler() == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Already listening");
        }
        this.listenContext = this.vertx.getOrCreateContext();
        this.listening = true;
        String host = address.host() != null ? address.host() : "localhost";
        int port = address.port();
        this.serverOrigin = (this.options.isSsl() ? "https" : "http") + "://" + host + ":" + port;
        List<HttpVersion> applicationProtocols = this.options.getAlpnVersions();
        if (this.listenContext.isWorkerContext()) {
            applicationProtocols = applicationProtocols.stream().filter(v -> v != HttpVersion.HTTP_2).collect(Collectors.toList());
        }
        this.sslHelper.setApplicationProtocols(applicationProtocols);
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            this.actualPort = port;
            this.id = new ServerID(port, host);
            HttpServerImpl shared = this.vertx.sharedHttpServers().get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), this.availableWorkers);
                this.applyConnectionOptions(address.path() != null, bootstrap);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(final Channel ch) throws Exception {
                        if (!HttpServerImpl.this.requestStream.accept() || !HttpServerImpl.this.wsStream.accept()) {
                            ch.close();
                            return;
                        }
                        final ChannelPipeline pipeline = ch.pipeline();
                        if (HttpServerImpl.this.sslHelper.isSSL()) {
                            ch.pipeline().addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler(ar -> {
                                if (ar.succeeded()) {
                                    if (HttpServerImpl.this.options.isUseAlpn()) {
                                        SslHandler sslHandler = pipeline.get(SslHandler.class);
                                        String protocol = sslHandler.applicationProtocol();
                                        if ("h2".equals(protocol)) {
                                            HttpServerImpl.this.handleHttp2(ch);
                                        } else {
                                            HttpServerImpl.this.handleHttp1(ch);
                                        }
                                    } else {
                                        HttpServerImpl.this.handleHttp1(ch);
                                    }
                                } else {
                                    HandlerHolder handler = HttpServerImpl.this.httpHandlerMgr.chooseHandler(ch.eventLoop());
                                    handler.context.executeFromIO(v -> ((HttpHandlers)handler.handler).exceptionHandler.handle(ar.cause()));
                                }
                            }));
                            if (HttpServerImpl.this.options.isSni()) {
                                SniHandler sniHandler = new SniHandler(HttpServerImpl.this.sslHelper.serverNameMapper(HttpServerImpl.this.vertx));
                                pipeline.addFirst(sniHandler);
                            } else {
                                SslHandler handler = new SslHandler(HttpServerImpl.this.sslHelper.createEngine(HttpServerImpl.this.vertx));
                                pipeline.addFirst("ssl", (ChannelHandler)handler);
                            }
                        } else if (HttpServerImpl.this.DISABLE_H2C) {
                            HttpServerImpl.this.handleHttp1(ch);
                        } else {
                            IdleStateHandler idle;
                            if (HttpServerImpl.this.options.getIdleTimeout() > 0) {
                                idle = new IdleStateHandler(0L, 0L, HttpServerImpl.this.options.getIdleTimeout(), HttpServerImpl.this.options.getIdleTimeoutUnit());
                                pipeline.addLast("idle", (ChannelHandler)idle);
                            } else {
                                idle = null;
                            }
                            pipeline.addLast(new Http1xOrH2CHandler(){

                                @Override
                                protected void configure(ChannelHandlerContext ctx, boolean h2c) {
                                    if (idle != null) {
                                        pipeline.remove(idle);
                                    }
                                    if (h2c) {
                                        HttpServerImpl.this.handleHttp2(ctx.channel());
                                    } else {
                                        HttpServerImpl.this.handleHttp1(ch);
                                    }
                                }

                                @Override
                                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                    if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                                        ctx.close();
                                    }
                                }

                                @Override
                                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                    super.exceptionCaught(ctx, cause);
                                    HandlerHolder handler = HttpServerImpl.this.httpHandlerMgr.chooseHandler(ctx.channel().eventLoop());
                                    handler.context.executeFromIO(v -> ((HttpHandlers)handler.handler).exceptionHandler.handle(cause));
                                }
                            });
                        }
                    }
                });
                this.addHandlers(this, this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, address, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.failed()) {
                            this.vertx.sharedHttpServers().remove(this.id);
                        } else {
                            Channel serverChannel = (Channel)res.result();
                            this.actualPort = serverChannel.localAddress() instanceof InetSocketAddress ? ((InetSocketAddress)serverChannel.localAddress()).getPort() : address.port();
                            this.serverChannelGroup.add(serverChannel);
                            VertxMetrics metrics = this.vertx.metricsSPI();
                            this.metrics = metrics != null ? metrics.createHttpServerMetrics(this.options, address) : null;
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return this;
                }
                this.vertx.sharedHttpServers().put(this.id, this);
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort;
                this.addHandlers(this.actualServer, this.listenContext);
                VertxMetrics metrics = this.vertx.metricsSPI();
                this.metrics = metrics != null ? metrics.createHttpServerMetrics(this.options, address) : null;
            }
            this.actualServer.bindFuture.addListener(future -> {
                if (listenHandler != null) {
                    Future<HttpServerImpl> res;
                    if (future.succeeded()) {
                        res = Future.succeededFuture(this);
                    } else {
                        res = Future.failedFuture(future.cause());
                        this.listening = false;
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(res));
                } else if (future.failed()) {
                    this.listening = false;
                    log.error(future.cause());
                }
            });
        }
        return this;
    }

    VertxHttp2ConnectionHandler<Http2ServerConnection> buildHttp2ConnectionHandler(HandlerHolder<HttpHandlers> holder) {
        Http2ConnectionHandler handler = ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder().server(true)).useCompression(this.options.isCompressionSupported()).useDecompression(this.options.isDecompressionSupported()).compressionLevel(this.options.getCompressionLevel()).initialSettings(this.options.getInitialSettings()).connectionFactory(connHandler -> new Http2ServerConnection(holder.context, this.serverOrigin, (VertxHttp2ConnectionHandler)connHandler, this.options, ((HttpHandlers)holder.handler).requestHandler, this.metrics)).logEnabled(this.logEnabled).build();
        ((VertxHttp2ConnectionHandler)handler).addHandler(conn -> {
            this.connectionMap.put(conn.channel(), (ConnectionBase)conn);
            if (this.metrics != null) {
                conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            if (this.options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(this.options.getHttp2ConnectionWindowSize());
            }
            if (((HttpHandlers)holder.handler).connectionHandler != null) {
                holder.context.executeFromIO(v -> ((HttpHandlers)holder.handler).connectionHandler.handle((HttpConnection)conn));
            }
        });
        ((VertxHttp2ConnectionHandler)handler).removeHandler(conn -> this.connectionMap.remove(conn.channel()));
        return handler;
    }

    private void configureHttp1(ChannelPipeline pipeline, HandlerHolder<HttpHandlers> holder) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (USE_FLASH_POLICY_HANDLER) {
            pipeline.addLast("flashpolicy", (ChannelHandler)new FlashPolicyHandler());
        }
        pipeline.addLast("httpDecoder", (ChannelHandler)new VertxHttpRequestDecoder(this.options));
        pipeline.addLast("httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
        if (this.options.isDecompressionSupported()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
        }
        if (this.options.isCompressionSupported()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpChunkContentCompressor(this.options.getCompressionLevel()));
        }
        if (this.sslHelper.isSSL() || this.options.isCompressionSupported()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
        if (!this.DISABLE_H2C) {
            pipeline.addLast("h2c", (ChannelHandler)new Http1xUpgradeToH2CHandler(this, this.httpHandlerMgr));
        }
        if (!DISABLE_WEBSOCKETS) {
            holder = new HandlerHolder<HttpHandlers>(holder.context, new HttpHandlers(this, new WebSocketRequestHandler(this.metrics, (HttpHandlers)holder.handler), ((HttpHandlers)holder.handler).wsHandler, ((HttpHandlers)holder.handler).connectionHandler, ((HttpHandlers)holder.handler).exceptionHandler));
            this.initializeWebsocketExtensions(pipeline);
        }
        HandlerHolder<HttpHandlers> holder2 = holder;
        VertxHandler<Http1xServerConnection> handler = VertxHandler.create(holder2.context, chctx -> {
            Http1xServerConnection conn = new Http1xServerConnection(holder2.context.owner(), this.sslHelper, this.options, (ChannelHandlerContext)chctx, holder2.context, this.serverOrigin, (HttpHandlers)holder2.handler, this.metrics);
            if (this.metrics != null) {
                holder2.context.executeFromIO(v -> conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName())));
            }
            return conn;
        });
        handler.addHandler(conn -> this.connectionMap.put(pipeline.channel(), (ConnectionBase)conn));
        handler.removeHandler(conn -> this.connectionMap.remove(pipeline.channel()));
        pipeline.addLast("handler", handler);
    }

    private void initializeWebsocketExtensions(ChannelPipeline pipeline) {
        ArrayList<WebSocketServerExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketServerExtensionHandshaker>();
        if (this.options.perFrameWebsocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.options.websocketCompressionLevel()));
        }
        if (this.options.perMessageWebsocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.options.websocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.options.getWebsocketAllowServerNoContext(), this.options.getWebsocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[extensionHandshakers.size()]));
            pipeline.addLast("websocketExtensionHandler", (ChannelHandler)extensionHandler);
        }
    }

    private void handleHttp1(Channel ch) {
        HandlerHolder<HttpHandlers> holder = this.httpHandlerMgr.chooseHandler(ch.eventLoop());
        if (holder == null) {
            this.sendServiceUnavailable(ch);
            return;
        }
        this.configureHttp1(ch.pipeline(), holder);
    }

    private void sendServiceUnavailable(Channel ch) {
        ch.writeAndFlush(Unpooled.copiedBuffer("HTTP/1.1 503 Service Unavailable\r\nContent-Length:0\r\n\r\n", StandardCharsets.ISO_8859_1)).addListener(ChannelFutureListener.CLOSE);
    }

    private void handleHttp2(Channel ch) {
        HandlerHolder<HttpHandlers> holder = this.httpHandlerMgr.chooseHandler(ch.eventLoop());
        if (holder == null) {
            ch.close();
            return;
        }
        VertxHttp2ConnectionHandler<Http2ServerConnection> handler = this.buildHttp2ConnectionHandler(holder);
        ch.pipeline().addLast("handler", handler);
        this.configureHttp2(ch.pipeline());
    }

    void configureHttp2(ChannelPipeline pipeline) {
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addBefore("handler", "idle", new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
    }

    public void closeAll(Handler<AsyncResult<Void>> handler) {
        List<HttpHandlers> list = this.httpHandlerMgr.handlers();
        List<Future> futures = list.stream().map(handlers -> Future.future(handlers.server::close)).collect(Collectors.toList());
        CompositeFuture fut = CompositeFuture.all(futures);
        fut.setHandler(ar -> handler.handle(ar.mapEmpty()));
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.wsStream.endHandler() != null || this.requestStream.endHandler() != null) {
            Handler<Void> wsEndHandler = this.wsStream.endHandler();
            this.wsStream.endHandler(null);
            Handler<Void> requestEndHandler = this.requestStream.endHandler();
            this.requestStream.endHandler(null);
            Handler<AsyncResult<Void>> next = done;
            done = event -> {
                if (event.succeeded()) {
                    if (wsEndHandler != null) {
                        wsEndHandler.handle((Void)event.result());
                    }
                    if (requestEndHandler != null) {
                        requestEndHandler.handle((Void)event.result());
                    }
                }
                if (next != null) {
                    next.handle((AsyncResult<Void>)event);
                }
            };
        }
        ContextInternal context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            this.executeCloseDone(context, done, null);
            return;
        }
        this.listening = false;
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.httpHandlerMgr.removeHandler(new HttpHandlers(this, this.requestStream.handler(), this.wsStream.handler(), this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler), this.listenContext);
                if (this.actualServer.httpHandlerMgr.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    public synchronized boolean isClosed() {
        return !this.listening;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    public SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    private void addHandlers(HttpServerImpl server, ContextInternal context) {
        server.httpHandlerMgr.addHandler(new HttpHandlers(this, this.requestStream.handler(), this.wsStream.handler(), this.connectionHandler, this.exceptionHandler == null ? DEFAULT_EXCEPTION_HANDLER : this.exceptionHandler), context);
    }

    private void actualClose(ContextInternal closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedHttpServers().remove(this.id);
        }
        ContextInternal currCon = this.vertx.getContext();
        for (ConnectionBase conn : this.connectionMap.values()) {
            conn.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        if (this.metrics != null) {
            this.metrics.close();
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)cgf -> this.executeCloseDone(closeContext, done, fut.cause())));
    }

    @Override
    public int actualPort() {
        return this.actualPort;
    }

    private void executeCloseDone(ContextInternal closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e != null ? Future.failedFuture(e) : Future.succeededFuture();
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class HttpStreamHandler<C extends ReadStream<Buffer>>
    implements ReadStream<C> {
        private Handler<C> handler;
        private long demand = Long.MAX_VALUE;
        private Handler<Void> endHandler;

        private HttpStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<C> handler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accept() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                boolean accept;
                boolean bl = accept = this.demand > 0L;
                if (accept && this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                return accept;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream handler(Handler<C> handler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (HttpServerImpl.this.listening) {
                    throw new IllegalStateException("Please set handler before server is listening");
                }
                this.handler = handler;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream pause() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = 0L;
                return this;
            }
        }

        @Override
        public ReadStream fetch(long amount) {
            if (amount > 0L) {
                this.demand += amount;
                if (this.demand < 0L) {
                    this.demand = Long.MAX_VALUE;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream resume() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.demand = Long.MAX_VALUE;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadStream endHandler(Handler<Void> endHandler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.endHandler = endHandler;
                return this;
            }
        }

        @Override
        public ReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

