/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.CharsetUtil;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.FileStreamChannel;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class VertxHttp2NetSocket<C extends Http2ConnectionBase>
extends VertxHttp2Stream<C>
implements NetSocket {
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> drainHandler;

    public VertxHttp2NetSocket(C conn, Http2Stream stream, boolean writable) {
        super(conn, stream, writable);
    }

    @Override
    void handleEnd(MultiMap trailers) {
        try {
            Handler<Void> handler = this.endHandler();
            if (handler != null) {
                handler.handle(null);
            }
        }
        finally {
            this.end();
        }
    }

    @Override
    void handleData(Buffer buf) {
        Handler<Buffer> handler = this.handler();
        if (handler != null) {
            handler.handle(buf);
        }
    }

    @Override
    void handleReset(long errorCode) {
        this.handleException(new StreamResetException(errorCode));
    }

    @Override
    void handleException(Throwable cause) {
        Handler<Throwable> handler = this.exceptionHandler();
        if (handler != null) {
            handler.handle(cause);
        }
    }

    @Override
    void handleClose() {
        Handler<Void> handler = this.closeHandler();
        if (handler != null) {
            handler.handle(null);
        }
    }

    @Override
    void handleInterestedOpsChanged() {
        Handler<Void> handler = this.drainHandler();
        if (handler != null && !this.writeQueueFull()) {
            handler.handle(null);
        }
    }

    @Override
    void handlePriorityChange(StreamPriority streamPriority) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.exceptionHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Throwable> exceptionHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.exceptionHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket handler(Handler<Buffer> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.dataHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Buffer> handler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.dataHandler;
        }
    }

    @Override
    public NetSocket fetch(long amount) {
        this.doFetch(amount);
        return this;
    }

    @Override
    public NetSocket pause() {
        this.doPause();
        return this;
    }

    @Override
    public NetSocket resume() {
        this.doResume();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket endHandler(Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.endHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> endHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.endHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket write(Buffer data) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.writeData(data.getByteBuf(), false);
            return this;
        }
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket drainHandler(Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.drainHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> drainHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.drainHandler;
        }
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    @Override
    public String writeHandlerID() {
        return null;
    }

    @Override
    public NetSocket write(String str) {
        return this.write(str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket write(String str, String enc) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            Charset cs = enc != null ? Charset.forName(enc) : CharsetUtil.UTF_8;
            this.writeData(Unpooled.copiedBuffer(str, cs), false);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket write(Buffer message, Handler<AsyncResult<Void>> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.conn.handler.writeData(this.stream, message.getByteBuf(), false, handler);
            return this;
        }
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            RandomAccessFile raf;
            ContextInternal resultCtx = resultHandler != null ? this.vertx.getOrCreateContext() : null;
            File file = this.vertx.resolveFile(filename);
            if (!file.exists()) {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.failedFuture(new FileNotFoundException())));
                }
                return this;
            }
            try {
                raf = new RandomAccessFile(file, "r");
            }
            catch (IOException e) {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
                }
                return this;
            }
            long contentLength = Math.min(length, file.length() - offset);
            Future<Long> result = Future.future();
            result.setHandler(ar -> {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.succeededFuture()));
                }
            });
            FileStreamChannel fileChannel = new FileStreamChannel(result, this, offset, contentLength);
            this.drainHandler((Handler)fileChannel.drainHandler);
            this.handlerContext.channel().eventLoop().register(fileChannel).addListener(future -> {
                if (future.isSuccess()) {
                    fileChannel.pipeline().fireUserEventTriggered(raf);
                } else {
                    result.tryFail(future.cause());
                }
            });
        }
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.writeData(Unpooled.EMPTY_BUFFER, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Buffer buffer) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.writeData(buffer.getByteBuf(), true);
        }
    }

    @Override
    public void close() {
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket closeHandler(@Nullable Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.closeHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> closeHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.closeHandler;
        }
    }

    @Override
    public NetSocket upgradeToSsl(Handler<Void> handler) {
        throw new UnsupportedOperationException("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public NetSocket upgradeToSsl(String serverName, Handler<Void> handler) {
        throw new UnsupportedOperationException("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public String indicatedServerName() {
        return this.conn.indicatedServerName();
    }
}

