/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.resolver;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.HostsFileParser;
import io.netty.resolver.NameResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.impl.netty.Fix;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.spi.resolver.ResolverProvider;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class DnsResolverProvider
implements ResolverProvider {
    private final Vertx vertx;
    private final List<ResolverRegistration> resolvers = Collections.synchronizedList(new ArrayList());
    private AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final List<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();

    public List<InetSocketAddress> nameServerAddresses() {
        return this.serverList;
    }

    public DnsResolverProvider(final VertxImpl vertx, final AddressResolverOptions options) {
        HostsFileEntries entries;
        List<String> dnsServers = options.getServers();
        if (dnsServers != null && dnsServers.size() > 0) {
            for (String dnsServer : dnsServers) {
                int port;
                String ipAddress;
                int sep = dnsServer.indexOf(58);
                if (sep != -1) {
                    ipAddress = dnsServer.substring(0, sep);
                    port = Integer.parseInt(dnsServer.substring(sep + 1));
                } else {
                    ipAddress = dnsServer;
                    port = 53;
                }
                try {
                    this.serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString(ipAddress)), port));
                }
                catch (UnknownHostException e) {
                    throw new VertxException(e);
                }
            }
        } else {
            InetSocketAddress address;
            DnsServerAddressStream stream = DefaultDnsServerAddressStreamProvider.defaultAddresses().stream();
            HashSet<InetSocketAddress> all = new HashSet<InetSocketAddress>();
            while (!all.contains(address = stream.next())) {
                this.serverList.add(address);
                all.add(address);
            }
        }
        DnsServerAddresses nameServerAddresses = options.isRotateServers() ? DnsServerAddresses.rotational(this.serverList) : DnsServerAddresses.sequential(this.serverList);
        final DnsServerAddressStreamProvider nameServerAddressProvider = hostname -> nameServerAddresses.stream();
        if (options.getHostsPath() != null) {
            File file = vertx.resolveFile(options.getHostsPath()).getAbsoluteFile();
            try {
                if (!file.exists() || !file.isFile()) {
                    throw new IOException();
                }
                entries = HostsFileParser.parse(file);
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts file " + file.getAbsolutePath());
            }
        } else if (options.getHostsValue() != null) {
            try {
                entries = HostsFileParser.parse(new StringReader(options.getHostsValue().toString()));
            }
            catch (IOException e) {
                throw new VertxException("Cannot read hosts config ", e);
            }
        } else {
            entries = HostsFileParser.parseSilently();
        }
        int minTtl = ObjectUtil.intValue(options.getCacheMinTimeToLive(), 0);
        int maxTtl = ObjectUtil.intValue(options.getCacheMaxTimeToLive(), Integer.MAX_VALUE);
        int negativeTtl = ObjectUtil.intValue(options.getCacheNegativeTimeToLive(), 0);
        final DefaultDnsCache resolveCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        final DefaultDnsCache authoritativeDnsServerCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        this.vertx = vertx;
        this.resolverGroup = new AddressResolverGroup<InetSocketAddress>(){

            @Override
            protected io.netty.resolver.AddressResolver<InetSocketAddress> newResolver(final EventExecutor executor) throws Exception {
                ChannelFactory<DatagramChannel> channelFactory = () -> vertx.transport().datagramChannel();
                DnsAddressResolverGroup group = new DnsAddressResolverGroup(channelFactory, nameServerAddressProvider){

                    @Override
                    protected NameResolver<InetAddress> newNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddressStreamProvider nameServerProvider) throws Exception {
                        DnsNameResolverBuilder builder = new DnsNameResolverBuilder((EventLoop)executor);
                        builder.hostsFileEntriesResolver(new HostsFileEntriesResolver(){

                            @Override
                            public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
                                InetAddress address = this.lookup(inetHost, resolvedAddressTypes);
                                if (address == null) {
                                    address = this.lookup(inetHost.toLowerCase(Locale.ENGLISH), resolvedAddressTypes);
                                }
                                return address;
                            }

                            InetAddress lookup(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
                                switch (resolvedAddressTypes) {
                                    case IPV4_ONLY: {
                                        return entries.inet4Entries().get(inetHost);
                                    }
                                    case IPV6_ONLY: {
                                        return entries.inet6Entries().get(inetHost);
                                    }
                                    case IPV4_PREFERRED: {
                                        Inet4Address inet4Address = entries.inet4Entries().get(inetHost);
                                        return inet4Address != null ? inet4Address : (InetAddress)entries.inet6Entries().get(inetHost);
                                    }
                                    case IPV6_PREFERRED: {
                                        Inet6Address inet6Address = entries.inet6Entries().get(inetHost);
                                        return inet6Address != null ? inet6Address : (InetAddress)entries.inet4Entries().get(inetHost);
                                    }
                                }
                                throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
                            }
                        });
                        builder.channelFactory(channelFactory);
                        builder.nameServerProvider(nameServerAddressProvider);
                        builder.optResourceEnabled(options.isOptResourceEnabled());
                        builder.resolveCache(resolveCache);
                        builder.authoritativeDnsServerCache(authoritativeDnsServerCache);
                        builder.queryTimeoutMillis(options.getQueryTimeout());
                        builder.maxQueriesPerResolve(options.getMaxQueries());
                        builder.recursionDesired(options.getRdFlag());
                        if (options.getSearchDomains() != null) {
                            builder.searchDomains(options.getSearchDomains());
                            int ndots = options.getNdots();
                            if (ndots == -1) {
                                ndots = AddressResolver.DEFAULT_NDOTS_RESOLV_OPTION;
                            }
                            builder.ndots(ndots);
                        } else {
                            builder.searchDomains(Fix.DEFAULT_SEARCH_DOMAINS);
                        }
                        return builder.build();
                    }
                };
                io.netty.resolver.AddressResolver<InetSocketAddress> resolver = group.getResolver(executor);
                DnsResolverProvider.this.resolvers.add(new ResolverRegistration(resolver, (EventLoop)executor));
                return resolver;
            }
        };
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions options) {
        return this.resolverGroup;
    }

    @Override
    public void close(Handler<Void> doneHandler) {
        Context context = this.vertx.getOrCreateContext();
        ResolverRegistration[] registrations = this.resolvers.toArray(new ResolverRegistration[this.resolvers.size()]);
        if (registrations.length == 0) {
            context.runOnContext(doneHandler);
            return;
        }
        AtomicInteger count = new AtomicInteger(registrations.length);
        for (ResolverRegistration registration : registrations) {
            Runnable task = () -> {
                registration.resolver.close();
                if (count.decrementAndGet() == 0) {
                    context.runOnContext(doneHandler);
                }
            };
            if (registration.executor.inEventLoop()) {
                task.run();
                continue;
            }
            registration.executor.execute(task);
        }
    }

    private static class ResolverRegistration {
        private final io.netty.resolver.AddressResolver<InetSocketAddress> resolver;
        private final EventLoop executor;

        ResolverRegistration(io.netty.resolver.AddressResolver<InetSocketAddress> resolver, EventLoop executor) {
            this.resolver = resolver;
            this.executor = executor;
        }
    }
}

