/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Json {
    public static ObjectMapper mapper = new ObjectMapper();
    public static ObjectMapper prettyMapper = new ObjectMapper();

    public static String encode(Object obj) throws EncodeException {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static Buffer encodeToBuffer(Object obj) throws EncodeException {
        try {
            return Buffer.buffer(mapper.writeValueAsBytes(obj));
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        try {
            return prettyMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, Class<T> clazz) throws DecodeException {
        try {
            return mapper.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        try {
            return mapper.readValue(str, type);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage(), e);
        }
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        try {
            return mapper.readValue((InputStream)new ByteBufInputStream(buf.getByteBuf()), type);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static <T> T decodeValue(Buffer buf, Class<T> clazz) throws DecodeException {
        try {
            return mapper.readValue((InputStream)new ByteBufInputStream(buf.getByteBuf()), clazz);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    static Object checkAndCopy(Object val, boolean copy) {
        if (!(val == null || val instanceof Number && !(val instanceof BigDecimal) || val instanceof Boolean || val instanceof String || val instanceof Character)) {
            if (val instanceof CharSequence) {
                val = val.toString();
            } else if (val instanceof JsonObject) {
                if (copy) {
                    val = ((JsonObject)val).copy();
                }
            } else if (val instanceof JsonArray) {
                if (copy) {
                    val = ((JsonArray)val).copy();
                }
            } else if (val instanceof Map) {
                val = copy ? new JsonObject((Map)val).copy() : new JsonObject((Map)val);
            } else if (val instanceof List) {
                val = copy ? new JsonArray((List)val).copy() : new JsonArray((List)val);
            } else if (val instanceof byte[]) {
                val = Base64.getEncoder().encodeToString((byte[])val);
            } else if (val instanceof Instant) {
                val = DateTimeFormatter.ISO_INSTANT.format((Instant)val);
            } else {
                throw new IllegalStateException("Illegal type in JsonObject: " + val.getClass());
            }
        }
        return val;
    }

    static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, new JsonObjectSerializer());
        module.addSerializer(JsonArray.class, new JsonArraySerializer());
        module.addSerializer(Instant.class, new InstantSerializer());
        module.addDeserializer(Instant.class, new InstantDeserializer());
        module.addSerializer(byte[].class, new ByteArraySerializer());
        module.addDeserializer(byte[].class, new ByteArrayDeserializer());
        mapper.registerModule(module);
        prettyMapper.registerModule(module);
    }

    private static class ByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        private ByteArrayDeserializer() {
        }

        @Override
        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String text = p.getText();
            try {
                return Base64.getDecoder().decode(text);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
            }
        }
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(Base64.getEncoder().encodeToString(value));
        }
    }

    private static class InstantDeserializer
    extends JsonDeserializer<Instant> {
        private InstantDeserializer() {
        }

        @Override
        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String text = p.getText();
            try {
                return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(text));
            }
            catch (DateTimeException e) {
                throw new InvalidFormatException(p, "Expected an ISO 8601 formatted date time", (Object)text, Instant.class);
            }
        }
    }

    private static class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        @Override
        public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(DateTimeFormatter.ISO_INSTANT.format(value));
        }
    }

    private static class JsonArraySerializer
    extends JsonSerializer<JsonArray> {
        private JsonArraySerializer() {
        }

        @Override
        public void serialize(JsonArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.getList());
        }
    }

    private static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        private JsonObjectSerializer() {
        }

        @Override
        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.getMap());
        }
    }
}

