/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class JsonObject
implements Iterable<Map.Entry<String, Object>>,
ClusterSerializable,
Shareable {
    private Map<String, Object> map;

    public JsonObject(String json) {
        this.fromJson(json);
    }

    public JsonObject() {
        this.map = new LinkedHashMap<String, Object>();
    }

    public JsonObject(Map<String, Object> map) {
        this.map = map;
    }

    public JsonObject(Buffer buf) {
        this.fromBuffer(buf);
    }

    public static JsonObject mapFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        return new JsonObject(Json.mapper.convertValue(obj, Map.class));
    }

    public <T> T mapTo(Class<T> type) {
        return Json.mapper.convertValue(this.map, type);
    }

    public String getString(String key) {
        Objects.requireNonNull(key);
        CharSequence cs = (CharSequence)this.map.get(key);
        return cs == null ? null : cs.toString();
    }

    public Integer getInteger(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public Long getLong(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public Double getDouble(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public Float getFloat(String key) {
        Objects.requireNonNull(key);
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return Float.valueOf(number.floatValue());
    }

    public Boolean getBoolean(String key) {
        Objects.requireNonNull(key);
        return (Boolean)this.map.get(key);
    }

    public JsonObject getJsonObject(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        }
        return (JsonObject)val;
    }

    public JsonArray getJsonArray(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return (JsonArray)val;
    }

    public byte[] getBinary(String key) {
        Objects.requireNonNull(key);
        String encoded = (String)this.map.get(key);
        return encoded == null ? null : Base64.getDecoder().decode(encoded);
    }

    public Instant getInstant(String key) {
        Objects.requireNonNull(key);
        String encoded = (String)this.map.get(key);
        return encoded == null ? null : Instant.from(DateTimeFormatter.ISO_INSTANT.parse(encoded));
    }

    public Object getValue(String key) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        } else if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return val;
    }

    public String getString(String key, String def) {
        Objects.requireNonNull(key);
        CharSequence cs = (CharSequence)this.map.get(key);
        return cs != null || this.map.containsKey(key) ? (cs == null ? null : cs.toString()) : def;
    }

    public Integer getInteger(String key, Integer def) {
        Objects.requireNonNull(key);
        Number val = (Number)this.map.get(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return val.intValue();
    }

    public Long getLong(String key, Long def) {
        Objects.requireNonNull(key);
        Number val = (Number)this.map.get(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        return val.longValue();
    }

    public Double getDouble(String key, Double def) {
        Objects.requireNonNull(key);
        Number val = (Number)this.map.get(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        return val.doubleValue();
    }

    public Float getFloat(String key, Float def) {
        Objects.requireNonNull(key);
        Number val = (Number)this.map.get(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        return Float.valueOf(val.floatValue());
    }

    public Boolean getBoolean(String key, Boolean def) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        return val != null || this.map.containsKey(key) ? (Boolean)val : def;
    }

    public JsonObject getJsonObject(String key, JsonObject def) {
        JsonObject val = this.getJsonObject(key);
        return val != null || this.map.containsKey(key) ? val : def;
    }

    public JsonArray getJsonArray(String key, JsonArray def) {
        JsonArray val = this.getJsonArray(key);
        return val != null || this.map.containsKey(key) ? val : def;
    }

    public byte[] getBinary(String key, byte[] def) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        return val != null || this.map.containsKey(key) ? (val == null ? null : Base64.getDecoder().decode((String)val)) : def;
    }

    public Instant getInstant(String key, Instant def) {
        Objects.requireNonNull(key);
        Object val = this.map.get(key);
        return val != null || this.map.containsKey(key) ? (val == null ? null : Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)val))) : def;
    }

    public Object getValue(String key, Object def) {
        Objects.requireNonNull(key);
        Object val = this.getValue(key);
        return val != null || this.map.containsKey(key) ? val : def;
    }

    public boolean containsKey(String key) {
        Objects.requireNonNull(key);
        return this.map.containsKey(key);
    }

    public Set<String> fieldNames() {
        return this.map.keySet();
    }

    public JsonObject put(String key, Enum value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : value.name());
        return this;
    }

    public JsonObject put(String key, CharSequence value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : value.toString());
        return this;
    }

    public JsonObject put(String key, String value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Integer value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Long value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Double value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Float value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Boolean value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject putNull(String key) {
        Objects.requireNonNull(key);
        this.map.put(key, null);
        return this;
    }

    public JsonObject put(String key, JsonObject value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, JsonArray value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, byte[] value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : Base64.getEncoder().encodeToString(value));
        return this;
    }

    public JsonObject put(String key, Instant value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : DateTimeFormatter.ISO_INSTANT.format(value));
        return this;
    }

    public JsonObject put(String key, Object value) {
        Objects.requireNonNull(key);
        value = Json.checkAndCopy(value, false);
        this.map.put(key, value);
        return this;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public JsonObject mergeIn(JsonObject other) {
        return this.mergeIn(other, false);
    }

    public JsonObject mergeIn(JsonObject other, boolean deep) {
        return this.mergeIn(other, deep ? Integer.MAX_VALUE : 1);
    }

    public JsonObject mergeIn(JsonObject other, int depth) {
        if (depth < 1) {
            return this;
        }
        if (depth == 1) {
            this.map.putAll(other.map);
            return this;
        }
        for (Map.Entry<String, Object> e : other.map.entrySet()) {
            if (e.getValue() == null) {
                this.map.put(e.getKey(), null);
                continue;
            }
            this.map.merge(e.getKey(), e.getValue(), (oldVal, newVal) -> {
                if (oldVal instanceof Map) {
                    oldVal = new JsonObject((Map)oldVal);
                }
                if (newVal instanceof Map) {
                    newVal = new JsonObject((Map)newVal);
                }
                if (oldVal instanceof JsonObject && newVal instanceof JsonObject) {
                    return ((JsonObject)oldVal).mergeIn((JsonObject)newVal, depth - 1);
                }
                return newVal;
            });
        }
        return this;
    }

    public String encode() {
        return Json.encode(this.map);
    }

    public String encodePrettily() {
        return Json.encodePrettily(this.map);
    }

    public Buffer toBuffer() {
        return Json.encodeToBuffer(this.map);
    }

    @Override
    public JsonObject copy() {
        HashMap copiedMap = this.map instanceof LinkedHashMap ? new LinkedHashMap(this.map.size()) : new HashMap(this.map.size());
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object val = entry.getValue();
            val = Json.checkAndCopy(val, true);
            copiedMap.put((String)entry.getKey(), (Object)val);
        }
        return new JsonObject(copiedMap);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return Json.asStream(this.iterator());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter(this.map.entrySet().iterator());
    }

    public int size() {
        return this.map.size();
    }

    @Fluent
    public JsonObject clear() {
        this.map.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return JsonObject.objectEquals(this.map, o);
    }

    static boolean objectEquals(Map<?, ?> m1, Object o2) {
        Map m2;
        if (o2 instanceof JsonObject) {
            m2 = ((JsonObject)o2).map;
        } else if (o2 instanceof Map) {
            m2 = (Map)o2;
        } else {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : m1.entrySet()) {
            Object val = entry.getValue();
            if (!(val == null ? m2.get(entry.getKey()) != null : !JsonObject.equals(entry.getValue(), m2.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof JsonObject) {
            return JsonObject.objectEquals(((JsonObject)o1).map, o2);
        }
        if (o1 instanceof Map) {
            return JsonObject.objectEquals((Map)o1, o2);
        }
        if (o1 instanceof JsonArray) {
            return JsonArray.arrayEquals(((JsonArray)o1).getList(), o2);
        }
        if (o1 instanceof List) {
            return JsonArray.arrayEquals((List)o1, o2);
        }
        if (o1 instanceof Number && o2 instanceof Number && o1.getClass() != o2.getClass()) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (o1 instanceof Float || o1 instanceof Double || o2 instanceof Float || o2 instanceof Double) {
                return n1.doubleValue() == n2.doubleValue();
            }
            return n1.longValue() == n2.longValue();
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        String encoded = this.encode();
        byte[] bytes = encoded.getBytes(StandardCharsets.UTF_8);
        buffer.appendInt(bytes.length);
        buffer.appendBytes(bytes);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start = pos + 4;
        String encoded = buffer.getString(start, start + length);
        this.fromJson(encoded);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.map = Json.decodeValue(json, Map.class);
    }

    private void fromBuffer(Buffer buf) {
        this.map = Json.decodeValue(buf, Map.class);
    }

    private static final class Entry
    implements Map.Entry<String, Object> {
        final String key;
        final Object value;

        public Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private class Iter
    implements Iterator<Map.Entry<String, Object>> {
        final Iterator<Map.Entry<String, Object>> mapIter;

        Iter(Iterator<Map.Entry<String, Object>> mapIter) {
            this.mapIter = mapIter;
        }

        @Override
        public boolean hasNext() {
            return this.mapIter.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> entry = this.mapIter.next();
            if (entry.getValue() instanceof Map) {
                return new Entry(entry.getKey(), new JsonObject((Map)entry.getValue()));
            }
            if (entry.getValue() instanceof List) {
                return new Entry(entry.getKey(), new JsonArray((List)entry.getValue()));
            }
            return entry;
        }

        @Override
        public void remove() {
            this.mapIter.remove();
        }
    }
}

