/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.Arguments;
import java.util.ArrayDeque;
import java.util.Objects;

public class InboundBuffer<E> {
    private final Context context;
    private final ArrayDeque<E> pending;
    private final long highWaterMark;
    private long demand;
    private Handler<E> handler;
    private boolean overflow;
    private Handler<Void> drainHandler;
    private Handler<Void> emptyHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean emitting;

    public InboundBuffer(Context context) {
        this(context, 16L);
    }

    public InboundBuffer(Context context, long highWaterMark) {
        Objects.requireNonNull(context, "context must not be null");
        Arguments.require(highWaterMark >= 0L, "highWaterMark " + highWaterMark + " >= 0");
        this.context = context;
        this.highWaterMark = highWaterMark;
        this.demand = Long.MAX_VALUE;
        this.pending = new ArrayDeque();
    }

    private void checkContext() {
        if (this.context != Vertx.currentContext()) {
            throw new IllegalStateException("This operation must be called from the context thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(E element) {
        Handler<E> handler;
        this.checkContext();
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            if (this.emitting || this.demand == 0L) {
                this.pending.add(element);
                boolean writable = (long)this.pending.size() <= this.highWaterMark;
                this.overflow |= !writable;
                return writable;
            }
            assert (this.pending.size() == 0);
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            this.emitting = true;
            handler = this.handler;
        }
        this.handleEvent(handler, element);
        return this.emitPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Iterable<E> elements) {
        this.checkContext();
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            for (E element : elements) {
                this.pending.add(element);
            }
            if (this.emitting || this.demand == 0L) {
                boolean writable = (long)this.pending.size() <= this.highWaterMark;
                this.overflow |= !writable;
                return writable;
            }
            this.emitting = true;
        }
        return this.emitPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean emitPending() {
        while (true) {
            Handler<E> handler;
            E element;
            InboundBuffer inboundBuffer = this;
            synchronized (inboundBuffer) {
                int size = this.pending.size();
                if (size == 0) {
                    this.checkCallDrainHandler();
                    this.emitting = false;
                    return true;
                }
                if (this.demand == 0L) {
                    this.emitting = false;
                    boolean writable = (long)this.pending.size() <= this.highWaterMark;
                    this.overflow |= !writable;
                    return writable;
                }
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                element = this.pending.poll();
                handler = this.handler;
            }
            this.handleEvent(handler, element);
        }
    }

    private void checkCallDrainHandler() {
        if (this.overflow) {
            this.overflow = false;
            this.context.runOnContext(v -> {
                Handler<Void> drainHandler;
                InboundBuffer inboundBuffer = this;
                synchronized (inboundBuffer) {
                    drainHandler = this.drainHandler;
                }
                this.handleEvent(drainHandler, null);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        Handler<Void> emptyHandler = null;
        while (true) {
            Handler<E> handler;
            E element;
            InboundBuffer inboundBuffer = this;
            synchronized (inboundBuffer) {
                int size = this.pending.size();
                if (size == 0) {
                    this.emitting = false;
                    this.checkCallDrainHandler();
                    emptyHandler = this.emptyHandler;
                    break;
                }
                if (this.demand == 0L) {
                    this.emitting = false;
                    return;
                }
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                element = this.pending.poll();
                handler = this.handler;
            }
            this.handleEvent(handler, element);
        }
        this.handleEvent(emptyHandler, null);
    }

    private <T> void handleEvent(Handler<T> handler, T element) {
        if (handler != null) {
            try {
                handler.handle(element);
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable err) {
        Handler<Throwable> handler;
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            handler = this.exceptionHandler;
            if (handler == null) {
                return;
            }
        }
        handler.handle(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundBuffer<E> fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            if (this.emitting || this.pending.isEmpty()) {
                return this;
            }
            this.emitting = true;
        }
        this.context.runOnContext(v -> this.drain());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E read() {
        InboundBuffer inboundBuffer = this;
        synchronized (inboundBuffer) {
            return this.pending.poll();
        }
    }

    public synchronized InboundBuffer<E> clear() {
        this.pending.clear();
        return this;
    }

    public synchronized InboundBuffer<E> pause() {
        this.demand = 0L;
        return this;
    }

    public InboundBuffer<E> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public synchronized InboundBuffer<E> handler(Handler<E> handler) {
        this.handler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> emptyHandler(Handler<Void> handler) {
        this.emptyHandler = handler;
        return this;
    }

    public synchronized InboundBuffer<E> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized boolean isEmpty() {
        return this.pending.isEmpty();
    }

    public synchronized boolean isWritable() {
        return (long)this.pending.size() <= this.highWaterMark;
    }

    public synchronized boolean isPaused() {
        return this.demand == 0L;
    }

    public synchronized int size() {
        return this.pending.size();
    }
}

