/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import java.net.URL;
import java.util.Scanner;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherMode;
import org.apache.camel.component.weather.WeatherUnits;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@UriParams
public class WeatherConfiguration {
    private final WeatherComponent component;
    @UriPath(description="The name value is not used.")
    @Metadata(required="true")
    private String name;
    @UriParam
    @Metadata(required="true")
    private String appid;
    @UriParam
    private String location = "";
    @UriParam
    private String lat;
    @UriParam
    private String lon;
    @UriParam
    private String period = "";
    @UriParam(defaultValue="JSON")
    private WeatherMode mode = WeatherMode.JSON;
    @UriParam(defaultValue="METRIC")
    private WeatherUnits units = WeatherUnits.METRIC;
    @UriParam
    private String headerName;

    public WeatherConfiguration(WeatherComponent component) {
        this.component = (WeatherComponent)((Object)ObjectHelper.notNull((Object)((Object)component), (String)"component"));
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        ObjectHelper.notNull((Object)period, (String)"period");
        int result = 0;
        try {
            result = new Scanner(period).useDelimiter("\\D+").nextInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != 0) {
            this.period = "" + result;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WeatherMode getMode() {
        return this.mode;
    }

    public void setMode(WeatherMode mode) {
        this.mode = (WeatherMode)((Object)ObjectHelper.notNull((Object)((Object)mode), (String)"mode"));
    }

    public WeatherUnits getUnits() {
        return this.units;
    }

    public void setUnits(WeatherUnits units) {
        this.units = (WeatherUnits)((Object)ObjectHelper.notNull((Object)((Object)units), (String)"units"));
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getLat() {
        return this.lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLon() {
        return this.lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getQuery() throws Exception {
        return this.getQuery(this.getLocation());
    }

    public String getQuery(String location) throws Exception {
        String answer = "http://api.openweathermap.org/data/2.5/";
        location = this.lat != null && this.lon != null ? "lat=" + this.lat + "&lon=" + this.lon : (ObjectHelper.isEmpty((Object)location) || "current".equals(location) ? this.getCurrentGeoLocation() : "q=" + location);
        answer = ObjectHelper.isEmpty((Object)this.getPeriod()) ? answer + "weather?" + location : answer + "forecast/daily?" + location + "&cnt=" + this.getPeriod();
        if (this.getUnits() != WeatherUnits.METRIC) {
            answer = answer + "&units=" + this.getUnits().name().toLowerCase();
        }
        if (this.getMode() != WeatherMode.JSON) {
            answer = answer + "&mode=" + this.getMode().name().toLowerCase();
        }
        if (this.getAppid() != null) {
            answer = answer + "&APPID=" + this.getAppid();
        }
        return answer;
    }

    private String getCurrentGeoLocation() throws Exception {
        String geoLocation = (String)this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)new URL("http://freegeoip.io/json/"));
        if (ObjectHelper.isEmpty((Object)geoLocation)) {
            throw new IllegalStateException("Got the unexpected value '" + geoLocation + "' for the geolocation");
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readValue(geoLocation, JsonNode.class);
        JsonNode latitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("latitude"), (String)"latitude");
        JsonNode longitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("longitude"), (String)"longitude");
        return "lat=" + latitudeNode + "&lon=" + longitudeNode;
    }
}

