/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherConsumer
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 3600000L;
    private static final Logger LOG = LoggerFactory.getLogger(WeatherConsumer.class);
    private String query;

    public WeatherConsumer(WeatherEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.query = this.getEndpoint().getWeatherQuery().getQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        LOG.debug("Going to execute the Weather query {}", (Object)this.query);
        CloseableHttpClient httpClient = this.getEndpoint().getConfiguration().getHttpClient();
        HttpGet getMethod = new HttpGet(this.query);
        try {
            HttpResponse response = httpClient.execute(getMethod);
            if (200 != response.getStatusLine().getStatusCode()) {
                LOG.warn("HTTP call for weather returned error status code {} - {} as a result with query: {}", new Object[]{this.status, response.getStatusLine().getStatusCode(), this.query});
                int n = 0;
                return n;
            }
            String weather = EntityUtils.toString(response.getEntity(), "UTF-8");
            LOG.debug("Got back the Weather information {}", (Object)weather);
            if (ObjectHelper.isEmpty(weather)) {
                int n = 0;
                return n;
            }
            Exchange exchange = this.getEndpoint().createExchange();
            String header = this.getEndpoint().getConfiguration().getHeaderName();
            if (header != null) {
                exchange.getIn().setHeader(header, weather);
            } else {
                exchange.getIn().setBody(weather);
            }
            exchange.getIn().setHeader("CamelWeatherQuery", this.query);
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

