/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherConfiguration;
import org.apache.camel.component.weather.WeatherConstants;
import org.apache.camel.component.weather.WeatherConsumer;
import org.apache.camel.component.weather.WeatherProducer;
import org.apache.camel.component.weather.WeatherQuery;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultPollingEndpoint;
import org.apache.http.client.utils.HttpClientUtils;

@UriEndpoint(firstVersion="2.12.0", scheme="weather", title="Weather", syntax="weather:name", category={Category.API}, headersClass=WeatherConstants.class)
public class WeatherEndpoint
extends DefaultPollingEndpoint {
    @UriParam
    private WeatherConfiguration configuration;
    private WeatherQuery weatherQuery;

    public WeatherEndpoint(String uri, WeatherComponent component, WeatherConfiguration properties) {
        super(uri, component);
        this.configuration = properties;
        this.weatherQuery = new WeatherQuery(this.getConfiguration());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        WeatherConsumer answer = new WeatherConsumer(this, processor);
        answer.setDelay(3600000L);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new WeatherProducer(this, this.getWeatherQuery().getQuery());
    }

    public WeatherConfiguration getConfiguration() {
        return this.configuration;
    }

    public WeatherQuery getWeatherQuery() {
        return this.weatherQuery;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        HttpClientUtils.closeQuietly(this.getConfiguration().getHttpClient());
    }
}

