/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Exchange;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(WeatherProducer.class);
    private final String query;

    public WeatherProducer(WeatherEndpoint endpoint, String query) {
        super(endpoint);
        this.query = query;
    }

    @Override
    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        String q = this.query;
        String location = exchange.getIn().getHeader("CamelWeatherLocation", String.class);
        if (location != null) {
            q = this.getEndpoint().getWeatherQuery().getQuery(location);
        }
        CloseableHttpClient httpClient = this.getEndpoint().getConfiguration().getHttpClient();
        HttpGet method = new HttpGet(q);
        try {
            LOG.debug("Going to execute the Weather query {}", (Object)q);
            HttpResponse response = httpClient.execute(method);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new IllegalStateException("Got the invalid http status value '" + response.getStatusLine().getStatusCode() + "' as the result of the query '" + this.query + "'");
            }
            String weather = EntityUtils.toString(response.getEntity(), "UTF-8");
            LOG.debug("Got back the Weather information {}", (Object)weather);
            if (ObjectHelper.isEmpty(weather)) {
                throw new IllegalStateException("Got the unexpected value '" + weather + "' as the result of the query '" + q + "'");
            }
            String header = this.getEndpoint().getConfiguration().getHeaderName();
            if (header != null) {
                exchange.getIn().setHeader(header, weather);
            } else {
                exchange.getIn().setBody(weather);
            }
            exchange.getIn().setHeader("CamelWeatherQuery", q);
        }
        finally {
            method.releaseConnection();
        }
    }
}

