/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.web3j;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Web3jEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":nodeAddress";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "web3j".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "nodeAddress", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(39);
        props.add("address");
        props.add("addresses");
        props.add("atBlock");
        props.add("blockHash");
        props.add("bridgeErrorHandler");
        props.add("clientId");
        props.add("data");
        props.add("databaseName");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("filterId");
        props.add("fromAddress");
        props.add("fromBlock");
        props.add("fullTransactionObjects");
        props.add("gasLimit");
        props.add("gasPrice");
        props.add("hashrate");
        props.add("headerPowHash");
        props.add("index");
        props.add("keyName");
        props.add("lazyStartProducer");
        props.add("mixDigest");
        props.add("nodeAddress");
        props.add("nonce");
        props.add("operation");
        props.add("position");
        props.add("priority");
        props.add("privateFor");
        props.add("quorumAPI");
        props.add("sha3HashOfDataToSign");
        props.add("signedTransactionData");
        props.add("sourceCode");
        props.add("toAddress");
        props.add("toBlock");
        props.add("topics");
        props.add("transactionHash");
        props.add("ttl");
        props.add("value");
        props.add("web3j");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

