/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.TypeDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class FunctionReturnDecoder {
    private FunctionReturnDecoder() {
    }

    public static List<Type> decode(String rawInput, List<TypeReference<Type>> outputParameters) {
        String input = Numeric.cleanHexPrefix(rawInput);
        if (Strings.isEmpty(input)) {
            return Collections.emptyList();
        }
        return FunctionReturnDecoder.build(input, outputParameters);
    }

    public static <T extends Type> Type decodeIndexedValue(String rawInput, TypeReference<T> typeReference) {
        String input = Numeric.cleanHexPrefix(rawInput);
        try {
            Class<T> type = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Class.forName(type.getName()));
            }
            if (Array.class.isAssignableFrom(type) || BytesType.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Bytes32.class);
            }
            return TypeDecoder.decode(input, type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                int length;
                Type result;
                Class<Type> type = typeReference.getClassType();
                int hexStringDataOffset = FunctionReturnDecoder.getDataOffset(input, offset, type);
                if (DynamicArray.class.isAssignableFrom(type)) {
                    result = TypeDecoder.decodeDynamicArray(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else if (StaticArray.class.isAssignableFrom(type)) {
                    length = Integer.parseInt(type.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else {
                    result = TypeDecoder.decode(input, hexStringDataOffset, type);
                    offset += 64;
                }
                results.add(result);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    private static <T extends Type> int getDataOffset(String input, int offset, Class<T> type) {
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || DynamicArray.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) << 1;
        }
        return offset;
    }
}

