/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.websocket;

import java.net.URI;
import java.util.Map;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.websocket.WebSocketListener;

public class WebSocketClient
extends org.java_websocket.client.WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private WebSocketListener listener;

    public WebSocketClient(URI serverUri) {
        super(serverUri);
    }

    public WebSocketClient(URI serverUri, Map<String, String> httpHeaders) {
        super(serverUri, httpHeaders);
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        log.info("Opened WebSocket connection to {}", (Object)this.uri);
    }

    @Override
    public void onMessage(String s) {
        try {
            log.debug("Received message {} from server {}", (Object)s, (Object)this.uri);
            this.listener.onMessage(s);
        }
        catch (Exception e) {
            log.error("Failed to process message '{}' from server {}", (Object)s, (Object)this.uri);
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        log.info("Closed WebSocket connection to {}, because of reason: '{}'.Conection closed remotely: {}", new Object[]{this.uri, reason, remote});
        this.listener.onClose();
    }

    @Override
    public void onError(Exception e) {
        log.error(String.format("WebSocket connection to {} failed with error", this.uri), (Throwable)e);
        this.listener.onError(e);
    }

    public void setListener(WebSocketListener listener) {
        this.listener = listener;
    }
}

