/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.io.Serializable;
import java.util.UUID;
import org.apache.camel.component.websocket.NodeSynchronization;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebsocket
implements WebSocket,
WebSocket.OnTextMessage,
WebSocket.OnBinaryMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWebsocket.class);
    private final WebsocketConsumer consumer;
    private final NodeSynchronization sync;
    private WebSocket.Connection connection;
    private String connectionKey;

    public DefaultWebsocket(NodeSynchronization sync, WebsocketConsumer consumer) {
        this.sync = sync;
        this.consumer = consumer;
    }

    @Override
    public void onClose(int closeCode, String message) {
        LOG.trace("onClose {} {}", (Object)closeCode, (Object)message);
        this.sync.removeSocket(this);
    }

    @Override
    public void onOpen(WebSocket.Connection connection) {
        LOG.trace("onOpen {}", (Object)connection);
        this.connection = connection;
        this.connectionKey = UUID.randomUUID().toString();
        this.sync.addSocket(this);
    }

    @Override
    public void onMessage(String message) {
        LOG.debug("onMessage: {}", (Object)message);
        if (this.consumer != null) {
            this.consumer.sendMessage(this.connectionKey, message);
        } else {
            LOG.debug("No consumer to handle message received: {}", (Object)message);
        }
    }

    @Override
    public void onMessage(byte[] data, int offset, int length) {
        LOG.debug("onMessage: byte[]");
        if (this.consumer != null) {
            byte[] message = new byte[length];
            System.arraycopy(data, offset, message, 0, length);
            this.consumer.sendMessage(this.connectionKey, message);
        } else {
            LOG.debug("No consumer to handle message received: byte[]");
        }
    }

    public WebSocket.Connection getConnection() {
        return this.connection;
    }

    public void setConnection(WebSocket.Connection connection) {
        this.connection = connection;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public void setConnectionKey(String connectionKey) {
        this.connectionKey = connectionKey;
    }
}

