/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.util.resource.Resource;

public class JettyClassPathResource
extends Resource {
    private final ClassResolver resolver;
    private final String path;

    public JettyClassPathResource(ClassResolver resolver, String path) {
        ObjectHelper.notNull((Object)resolver, (String)"ClassResolver");
        ObjectHelper.notNull((Object)path, (String)"path");
        this.resolver = resolver;
        this.path = path;
    }

    @Override
    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean exists() {
        InputStream is = this.resolver.loadResourceAsStream(this.path);
        if (is != null) {
            IOHelper.close((Closeable)is);
        }
        return is != null;
    }

    @Override
    public boolean isDirectory() {
        return this.exists() && this.path.endsWith("/");
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public URL getURL() {
        return this.resolver.loadResourceAsURL(this.path);
    }

    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            return new File(url.getFile());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resolver.loadResourceAsStream(this.path);
    }

    @Override
    public OutputStream getOutputStream() throws IOException, SecurityException {
        return null;
    }

    @Override
    public boolean delete() throws SecurityException {
        return false;
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }

    @Override
    public String[] list() {
        return new String[0];
    }

    @Override
    public Resource addPath(String path) throws IOException, MalformedURLException {
        return new JettyClassPathResource(this.resolver, this.path + "/" + path);
    }
}

