/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.servlet.DispatcherType;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.websocket.NodeSynchronization;
import org.apache.camel.component.websocket.WebsocketComponentServlet;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.apache.camel.component.websocket.WebsocketEndpoint;
import org.apache.camel.component.websocket.WebsocketProducer;
import org.apache.camel.component.websocket.WebsocketProducerConsumer;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketComponent
extends UriEndpointComponent {
    protected static final Logger LOG = LoggerFactory.getLogger(WebsocketComponent.class);
    protected static final HashMap<String, ConnectorRef> CONNECTORS = new HashMap();
    protected SSLContextParameters sslContextParameters;
    protected MBeanContainer mbContainer;
    protected ThreadPool threadPool;
    protected Integer port = 9292;
    protected Integer minThreads;
    protected Integer maxThreads;
    protected boolean enableJmx;
    protected String host = "0.0.0.0";
    protected String staticResources;
    protected Server staticResourcesServer;
    protected String sslKeyPassword;
    protected String sslPassword;
    protected String sslKeystore;
    private Map<String, WebsocketComponentServlet> servlets = new HashMap<String, WebsocketComponentServlet>();

    public WebsocketComponent() {
        super(WebsocketEndpoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(WebsocketProducerConsumer prodcon) throws Exception {
        Server server = null;
        WebsocketEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = WebsocketComponent.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef == null) {
                Connector connector = endpoint.getSslContextParameters() != null ? this.getSslSocketConnector(endpoint.getSslContextParameters()) : new SelectChannelConnector();
                LOG.trace("Jetty Connector added: {}", (Object)connector.getName());
                if (endpoint.getPort() != null) {
                    connector.setPort(endpoint.getPort());
                } else {
                    connector.setPort(this.port);
                }
                if (endpoint.getHost() != null) {
                    connector.setHost(endpoint.getHost());
                } else {
                    connector.setHost(this.host);
                }
                server = this.createServer();
                if (endpoint.isEnableJmx()) {
                    this.enableJmx(server);
                }
                server.addConnector(connector);
                ServletContextHandler context = this.createContext(server, connector, endpoint.getHandlers());
                this.setWebSocketComponentServletInitialParameter(context, endpoint);
                server.setHandler(context);
                this.applyCrossOriginFiltering(endpoint, context);
                if (endpoint.getStaticResources() != null) {
                    server = this.createStaticResourcesServer(server, context, endpoint.getStaticResources());
                }
                connectorRef = new ConnectorRef(server, connector, null);
                if (endpoint.isSessionSupport()) {
                    this.enableSessionSupport(connectorRef.server, connectorKey);
                }
                LOG.info("Jetty Server starting on host: {}:{}", (Object)connector.getHost(), (Object)connector.getPort());
                connectorRef.server.start();
                CONNECTORS.put(connectorKey, connectorRef);
            } else {
                connectorRef.increment();
            }
            if (endpoint.isSessionSupport()) {
                this.enableSessionSupport(connectorRef.server, connectorKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(WebsocketProducerConsumer prodcon) throws Exception {
        WebsocketEndpoint endpoint = prodcon.getEndpoint();
        String connectorKey = WebsocketComponent.getConnectorKey(endpoint);
        HashMap<String, ConnectorRef> hashMap = CONNECTORS;
        synchronized (hashMap) {
            ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
            if (connectorRef != null) {
                if (connectorRef.decrement() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    if (connectorRef.connector != null) {
                        connectorRef.connector.stop();
                    }
                    connectorRef.server.stop();
                    CONNECTORS.remove(connectorKey);
                    if (this.mbContainer != null) {
                        this.mbContainer.removeBean(connectorRef.server);
                        this.mbContainer.removeBean(connectorRef.connector);
                    }
                }
                if (prodcon instanceof WebsocketConsumer) {
                    connectorRef.servlet.disconnect((WebsocketConsumer)prodcon);
                }
            }
        }
    }

    public synchronized MBeanContainer getMbContainer() {
        if (this.mbContainer == null) {
            MBeanServer mbs = null;
            ManagementStrategy mStrategy = this.getCamelContext().getManagementStrategy();
            ManagementAgent mAgent = mStrategy.getManagementAgent();
            if (mAgent != null) {
                mbs = mAgent.getMBeanServer();
            }
            if (mbs != null) {
                this.mbContainer = new MBeanContainer(mbs);
                this.startMbContainer();
            } else {
                LOG.warn("JMX disabled in CamelContext. Jetty JMX extensions will remain disabled.");
            }
        }
        return this.mbContainer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParametersRef", SSLContextParameters.class);
        if (sslContextParameters == null) {
            sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        }
        Boolean enableJmx = (Boolean)this.getAndRemoveParameter(parameters, "enableJmx", Boolean.class);
        String staticResources = (String)this.getAndRemoveParameter(parameters, "staticResources", String.class);
        int port = this.extractPortNumber(remaining);
        String host = this.extractHostName(remaining);
        WebsocketEndpoint endpoint = new WebsocketEndpoint(this, uri, remaining, parameters);
        if (enableJmx != null) {
            endpoint.setEnableJmx(enableJmx);
        } else {
            endpoint.setEnableJmx(this.isEnableJmx());
        }
        if (sslContextParameters == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        if (sslContextParameters != null) {
            endpoint.setSslContextParameters(sslContextParameters);
        }
        if (staticResources == null) {
            staticResources = this.getStaticResources();
        }
        if (staticResources != null) {
            endpoint.setStaticResources(staticResources);
        }
        endpoint.setSslContextParameters(sslContextParameters);
        endpoint.setPort(port);
        endpoint.setHost(host);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void setWebSocketComponentServletInitialParameter(ServletContextHandler context, WebsocketEndpoint endpoint) {
        if (endpoint.getBufferSize() != null) {
            context.setInitParameter("bufferSize", endpoint.getBufferSize().toString());
        }
        if (endpoint.getMaxIdleTime() != null) {
            context.setInitParameter("maxIdleTime", endpoint.getMaxIdleTime().toString());
        }
        if (endpoint.getMaxTextMessageSize() != null) {
            context.setInitParameter("maxTextMessageSize", endpoint.getMaxTextMessageSize().toString());
        }
        if (endpoint.getMaxBinaryMessageSize() != null) {
            context.setInitParameter("maxBinaryMessageSize", endpoint.getMaxBinaryMessageSize().toString());
        }
        if (endpoint.getMinVersion() != null) {
            context.setInitParameter("minVersion", endpoint.getMinVersion().toString());
        }
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler(collection);
        if (this.minThreads != null || this.maxThreads != null) {
            if (this.getThreadPool() != null) {
                throw new IllegalArgumentException("You cannot configure both minThreads/maxThreads and a custom threadPool on JettyHttpComponent: " + (Object)((Object)this));
            }
            QueuedThreadPool qtp = new QueuedThreadPool();
            if (this.minThreads != null) {
                qtp.setMinThreads(this.minThreads);
            }
            if (this.maxThreads != null) {
                qtp.setMaxThreads(this.maxThreads);
            }
            qtp.setName("CamelJettyWebSocketServer(" + ObjectHelper.getIdentityHashCode((Object)server) + ")");
            try {
                qtp.start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error starting JettyWebSocketServer thread pool: " + qtp, (Throwable)e);
            }
            server.setThreadPool(qtp);
        }
        if (this.getThreadPool() != null) {
            server.setThreadPool(this.getThreadPool());
        }
        return server;
    }

    protected Server createStaticResourcesServer(Server server, ServletContextHandler context, String home) throws Exception {
        context.setContextPath("/");
        HashSessionManager sm = new HashSessionManager();
        SessionHandler sh = new SessionHandler(sm);
        context.setSessionHandler(sh);
        if (home != null) {
            String[] resources = home.split(":");
            if (LOG.isDebugEnabled()) {
                LOG.debug(">>> Protocol found: " + resources[0] + ", and resource: " + resources[1]);
            }
            if (resources[0].equals("classpath")) {
                URL url = this.getCamelContext().getClassResolver().loadResourceAsURL(resources[1]);
                context.setBaseResource(Resource.newResource(url));
            } else if (resources[0].equals("file")) {
                context.setBaseResource(Resource.newResource(resources[1]));
            }
            DefaultServlet defaultServlet = new DefaultServlet();
            ServletHolder holder = new ServletHolder(defaultServlet);
            holder.setInitParameter("useFileMappedBuffer", "false");
            context.addServlet(holder, "/");
        }
        server.setHandler(context);
        return server;
    }

    protected Server createStaticResourcesServer(ServletContextHandler context, String host, int port, String home) throws Exception {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(host);
        connector.setPort(port);
        server.addConnector(connector);
        return this.createStaticResourcesServer(server, context, home);
    }

    protected WebsocketComponentServlet addServlet(NodeSynchronization sync, WebsocketProducer producer, String remaining) throws Exception {
        WebsocketEndpoint endpoint = producer.getEndpoint();
        String key = WebsocketComponent.getConnectorKey(endpoint);
        ConnectorRef connectorRef = WebsocketComponent.getConnectors().get(key);
        if (connectorRef != null) {
            String pathSpec = WebsocketComponent.createPathSpec(remaining);
            WebsocketComponentServlet servlet = this.servlets.get(pathSpec);
            if (servlet == null) {
                ServletContextHandler context = (ServletContextHandler)connectorRef.server.getHandler();
                connectorRef.servlet = servlet = this.createServlet(sync, pathSpec, this.servlets, context);
                LOG.debug("WebSocket Producer Servlet added for the following path : " + pathSpec + ", to the Jetty Server : " + key);
            }
            return servlet;
        }
        throw new Exception("Jetty instance has not been retrieved for : " + key);
    }

    protected WebsocketComponentServlet addServlet(NodeSynchronization sync, WebsocketConsumer consumer, String resourceUri) throws Exception {
        WebsocketEndpoint endpoint = consumer.getEndpoint();
        String key = WebsocketComponent.getConnectorKey(endpoint);
        ConnectorRef connectorRef = WebsocketComponent.getConnectors().get(key);
        if (connectorRef != null) {
            String pathSpec = WebsocketComponent.createPathSpec(resourceUri);
            WebsocketComponentServlet servlet = this.servlets.get(pathSpec);
            if (servlet == null) {
                ServletContextHandler context = (ServletContextHandler)connectorRef.server.getHandler();
                connectorRef.servlet = servlet = this.createServlet(sync, pathSpec, this.servlets, context);
                this.servlets.put(pathSpec, servlet);
                LOG.debug("WebSocket servlet added for the following path : " + pathSpec + ", to the Jetty Server : " + key);
            }
            if (servlet.getConsumer() == null) {
                servlet.setConsumer(consumer);
            }
            servlet.connect(consumer);
            return servlet;
        }
        throw new Exception("Jetty instance has not been retrieved for : " + key);
    }

    protected WebsocketComponentServlet createServlet(NodeSynchronization sync, String pathSpec, Map<String, WebsocketComponentServlet> servlets, ServletContextHandler handler) {
        WebsocketComponentServlet servlet = new WebsocketComponentServlet(sync);
        servlets.put(pathSpec, servlet);
        handler.addServlet(new ServletHolder(servlet), pathSpec);
        return servlet;
    }

    protected ServletContextHandler createContext(Server server, Connector connector, List<Handler> handlers) throws Exception {
        ServletContextHandler context = new ServletContextHandler(server, "/", 0);
        context.setConnectorNames(new String[]{connector.getName()});
        if (handlers != null && !handlers.isEmpty()) {
            for (Handler handler : handlers) {
                if (handler instanceof HandlerWrapper) {
                    ((HandlerWrapper)handler).setHandler(server.getHandler());
                    server.setHandler(handler);
                    continue;
                }
                HandlerCollection handlerCollection = new HandlerCollection();
                handlerCollection.addHandler(server.getHandler());
                handlerCollection.addHandler(handler);
                server.setHandler(handlerCollection);
            }
        }
        return context;
    }

    protected void startMbContainer() {
        if (this.mbContainer != null && !this.mbContainer.isStarted()) {
            try {
                this.mbContainer.start();
                this.mbContainer.addBean(this.mbContainer);
            }
            catch (Throwable e) {
                LOG.warn("Could not start JettyWebSocket MBeanContainer. Jetty JMX extensions will remain disabled.", e);
            }
        }
    }

    private void enableSessionSupport(Server server, String connectorKey) throws Exception {
        ServletContextHandler context = server.getChildHandlerByClass(ServletContextHandler.class);
        if (context.getSessionHandler() == null) {
            SessionHandler sessionHandler = new SessionHandler();
            if (context.isStarted()) {
                throw new IllegalStateException("Server has already been started. Cannot enabled sessionSupport on " + connectorKey);
            }
            context.setSessionHandler(sessionHandler);
        }
    }

    private SslConnector getSslSocketConnector(SSLContextParameters sslContextParameters) throws Exception {
        SslSelectChannelConnector sslSocketConnector = null;
        if (sslContextParameters != null) {
            WebSocketComponentSslContextFactory sslContextFactory = new WebSocketComponentSslContextFactory();
            sslContextFactory.setSslContext(sslContextParameters.createSSLContext());
            sslSocketConnector = new SslSelectChannelConnector(sslContextFactory);
        } else {
            sslSocketConnector = new SslSelectChannelConnector();
            sslSocketConnector.getSslContextFactory().setKeyManagerPassword(this.sslPassword);
            sslSocketConnector.getSslContextFactory().setKeyStorePassword(this.sslKeyPassword);
            if (this.sslKeystore != null) {
                sslSocketConnector.getSslContextFactory().setKeyStorePath(this.sslKeystore);
            }
        }
        return sslSocketConnector;
    }

    private static boolean checkSSLContextFactoryConfig(Object instance) {
        try {
            Method method = instance.getClass().getMethod("checkConfig", new Class[0]);
            return (Boolean)method.invoke(instance, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    private static String createPathSpec(String remaining) {
        int index = remaining.indexOf("/");
        if (index != -1) {
            return remaining.substring(index, remaining.length());
        }
        return "/" + remaining;
    }

    private int extractPortNumber(String remaining) {
        int index1 = remaining.indexOf(":");
        int index2 = remaining.indexOf("/");
        if (index1 != -1 && index2 != -1) {
            String result = remaining.substring(index1 + 1, index2);
            return Integer.parseInt(result);
        }
        return this.port;
    }

    private String extractHostName(String remaining) {
        int index = remaining.indexOf(":");
        if (index != -1) {
            return remaining.substring(0, index);
        }
        return this.host;
    }

    private static String getConnectorKey(WebsocketEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getHost() + ":" + endpoint.getPort();
    }

    private void enableJmx(Server server) {
        MBeanContainer containerToRegister = this.getMbContainer();
        if (containerToRegister != null) {
            LOG.info("Jetty JMX Extensions is enabled");
            server.getContainer().addEventListener(containerToRegister);
        }
    }

    private void applyCrossOriginFiltering(WebsocketEndpoint endpoint, ServletContextHandler context) {
        if (endpoint.isCrossOriginFilterOn()) {
            FilterHolder filterHolder = new FilterHolder();
            CrossOriginFilter filter = new CrossOriginFilter();
            filterHolder.setFilter(filter);
            filterHolder.setInitParameter("allowedOrigins", endpoint.getAllowedOrigins());
            context.addFilter(filterHolder, endpoint.getFilterPath(), EnumSet.allOf(DispatcherType.class));
        }
    }

    public String getStaticResources() {
        return this.staticResources;
    }

    public void setStaticResources(String staticResources) {
        this.staticResources = staticResources;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSslPassword() {
        return this.sslPassword;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public static HashMap<String, ConnectorRef> getConnectors() {
        return CONNECTORS;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.staticResources != null) {
            ObjectHelper.notEmpty((String)this.host, (String)"host", (Object)((Object)this));
            ObjectHelper.notNull((Object)this.port, (String)"port", (Object)((Object)this));
            LOG.info("Starting static resources server {}:{} with static resource: {}", new Object[]{this.host, this.port, this.staticResources});
            ServletContextHandler context = new ServletContextHandler(1);
            this.staticResourcesServer = this.createStaticResourcesServer(context, this.host, this.port, this.staticResources);
            this.staticResourcesServer.start();
            Connector connector = this.staticResourcesServer.getConnectors()[0];
            ConnectorRef ref = new ConnectorRef(this.staticResourcesServer, connector, null);
            String key = "websocket:" + this.host + ":" + this.port;
            CONNECTORS.put(key, ref);
        }
    }

    public void doStop() throws Exception {
        super.doStop();
        if (CONNECTORS.size() > 0) {
            for (String connectorKey : CONNECTORS.keySet()) {
                ConnectorRef connectorRef = CONNECTORS.get(connectorKey);
                if (connectorRef != null && connectorRef.getRefCount() == 0) {
                    connectorRef.server.removeConnector(connectorRef.connector);
                    connectorRef.connector.stop();
                    connectorRef.server.stop();
                    connectorRef.servlet = null;
                }
                CONNECTORS.remove(connectorKey);
            }
        }
        CONNECTORS.clear();
        if (this.staticResourcesServer != null) {
            LOG.info("Stopping static resources server {}:{} with static resource: {}", new Object[]{this.host, this.port, this.staticResources});
            this.staticResourcesServer.stop();
            this.staticResourcesServer.destroy();
            this.staticResourcesServer = null;
        }
        this.servlets.clear();
    }

    private static final class WebSocketComponentSslContextFactory
    extends SslContextFactory {
        private WebSocketComponentSslContextFactory() {
        }

        public boolean checkConfig() {
            if (this.getSslContext() == null) {
                return WebsocketComponent.checkSSLContextFactoryConfig(this);
            }
            return true;
        }

        @Override
        public void checkKeyStore() {
        }
    }

    class ConnectorRef {
        Server server;
        Connector connector;
        WebsocketComponentServlet servlet;
        int refCount;

        public ConnectorRef(Server server, Connector connector, WebsocketComponentServlet servlet) {
            this.server = server;
            this.connector = connector;
            this.servlet = servlet;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }
}

