/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.server.ServerContainer;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.websocket.jsr356.CamelServerEndpoint;
import org.apache.camel.websocket.jsr356.DefaultServerEndpointDeploymentStrategy;
import org.apache.camel.websocket.jsr356.JSR356Endpoint;
import org.apache.camel.websocket.jsr356.ServerEndpointDeploymentStrategy;

@Component(value="websocket-jsr356")
public class JSR356WebSocketComponent
extends DefaultComponent {
    private static final Map<String, ContextBag> SERVER_CONTAINERS = new ConcurrentHashMap<String, ContextBag>();
    @Metadata(label="advanced")
    private ServerEndpointDeploymentStrategy serverEndpointDeploymentStrategy;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JSR356Endpoint endpoint = new JSR356Endpoint(this, uri);
        endpoint.setUri(new URI(remaining));
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public static void registerServer(String contextPath, ServerContainer container) {
        SERVER_CONTAINERS.put(contextPath, new ContextBag(container));
    }

    public static void unregisterServer(String contextPath) {
        SERVER_CONTAINERS.remove(contextPath);
    }

    public static ContextBag getContext(String context) {
        return Optional.ofNullable(context).map(SERVER_CONTAINERS::get).orElseGet(() -> SERVER_CONTAINERS.size() == 1 ? SERVER_CONTAINERS.values().iterator().next() : SERVER_CONTAINERS.get(""));
    }

    public ServerEndpointDeploymentStrategy getServerEndpointDeploymentStrategy() {
        if (this.serverEndpointDeploymentStrategy == null) {
            this.serverEndpointDeploymentStrategy = new DefaultServerEndpointDeploymentStrategy();
        }
        return this.serverEndpointDeploymentStrategy;
    }

    public void setServerEndpointDeploymentStrategy(ServerEndpointDeploymentStrategy serverEndpointDeploymentStrategy) {
        this.serverEndpointDeploymentStrategy = serverEndpointDeploymentStrategy;
    }

    public static final class ContextBag {
        private final ServerContainer container;
        private final Map<String, CamelServerEndpoint> endpoints = new HashMap<String, CamelServerEndpoint>();

        private ContextBag(ServerContainer container) {
            this.container = container;
        }

        public ServerContainer getContainer() {
            return this.container;
        }

        public Map<String, CamelServerEndpoint> getEndpoints() {
            return this.endpoints;
        }
    }
}

