/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import org.apache.camel.component.wordpress.api.WordpressAPIConfiguration;
import org.apache.camel.component.wordpress.api.service.WordpressService;
import org.apache.camel.component.wordpress.api.service.WordpressServicePosts;
import org.apache.camel.component.wordpress.api.service.WordpressServiceUsers;
import org.apache.camel.component.wordpress.api.service.impl.WordpressServicePostsAdapter;
import org.apache.camel.component.wordpress.api.service.impl.WordpressServiceUsersAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WordpressServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WordpressServiceProvider.class);
    private HashMap<Class<? extends WordpressService>, WordpressService> services;
    private WordpressAPIConfiguration configuration;

    private WordpressServiceProvider() {
    }

    public static WordpressServiceProvider getInstance() {
        return ServiceProviderHolder.INSTANCE;
    }

    public void init(String wordpressApiUrl) {
        this.init(wordpressApiUrl, "2");
    }

    public void init(String wordpressApiUrl, String apiVersion) {
        this.init(new WordpressAPIConfiguration(wordpressApiUrl, apiVersion));
    }

    public void init(WordpressAPIConfiguration config) {
        Preconditions.checkNotNull(Strings.emptyToNull(config.getApiUrl()), "Please inform the Wordpress API url , eg.: http://myblog.com/wp-json/wp");
        if (Strings.isNullOrEmpty(config.getApiVersion())) {
            config.setApiVersion("2");
        }
        WordpressServicePostsAdapter servicePosts = new WordpressServicePostsAdapter(config.getApiUrl(), config.getApiVersion());
        WordpressServiceUsersAdapter serviceUsers = new WordpressServiceUsersAdapter(config.getApiUrl(), config.getApiVersion());
        servicePosts.setWordpressAuthentication(config.getAuthentication());
        serviceUsers.setWordpressAuthentication(config.getAuthentication());
        this.services = new HashMap();
        this.services.put(WordpressServicePosts.class, servicePosts);
        this.services.put(WordpressServiceUsers.class, serviceUsers);
        this.configuration = config;
        LOGGER.info("Wordpress Service Provider initialized using base URL: {}, API Version {}", (Object)config.getApiUrl(), (Object)config.getApiVersion());
    }

    public <T extends WordpressService> T getService(Class<T> wordpressServiceClazz) {
        WordpressService service = this.services.get(wordpressServiceClazz);
        if (service == null) {
            throw new IllegalArgumentException(String.format("Couldn't find a Wordpress Service '%s'", wordpressServiceClazz));
        }
        return (T)service;
    }

    public boolean hasAuthentication() {
        if (this.configuration != null) {
            return this.configuration.getAuthentication() != null;
        }
        return false;
    }

    private static class ServiceProviderHolder {
        private static final WordpressServiceProvider INSTANCE = new WordpressServiceProvider();

        private ServiceProviderHolder() {
        }
    }
}

