/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.model.Tag;
import org.apache.camel.component.wordpress.api.model.TagSearchCriteria;
import org.apache.camel.component.wordpress.api.service.WordpressServiceTags;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressCrudServiceAdapter;
import org.apache.camel.component.wordpress.api.service.spi.TagsSPI;

public class WordpressServiceTagsAdapter
extends AbstractWordpressCrudServiceAdapter<TagsSPI, Tag, TagSearchCriteria>
implements WordpressServiceTags {
    public WordpressServiceTagsAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    protected Class<TagsSPI> getSpiType() {
        return TagsSPI.class;
    }

    @Override
    public List<Tag> list(TagSearchCriteria criteria) {
        Preconditions.checkNotNull(criteria, "The search criteria must be defined");
        return ((TagsSPI)this.getSpi()).list(this.getApiVersion(), criteria.getContext(), criteria.getPage(), criteria.getPerPage(), criteria.getSearch(), criteria.getExclude(), criteria.getInclude(), criteria.getOffset(), criteria.getOrder(), criteria.getOrderBy(), criteria.isHideEmpty(), criteria.getPostId(), criteria.getSlug());
    }

    @Override
    protected Tag doCreate(Tag object) {
        return ((TagsSPI)this.getSpi()).create(this.getApiVersion(), object);
    }

    @Override
    protected Tag doDelete(Integer id) {
        return ((TagsSPI)this.getSpi()).delete(this.getApiVersion(), id, false);
    }

    @Override
    protected Tag doUpdate(Integer id, Tag object) {
        return ((TagsSPI)this.getSpi()).update(this.getApiVersion(), id, object);
    }

    @Override
    protected Tag doRetrieve(Integer entityID, Context context) {
        return ((TagsSPI)this.getSpi()).retrieve(this.getApiVersion(), entityID, context);
    }
}

