/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.model.Taxonomy;
import org.apache.camel.component.wordpress.api.service.WordpressServiceTaxonomy;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressServiceAdapter;
import org.apache.camel.component.wordpress.api.service.spi.TaxonomySPI;

public class WordpressServiceTaxonomyAdapter
extends AbstractWordpressServiceAdapter<TaxonomySPI>
implements WordpressServiceTaxonomy {
    public WordpressServiceTaxonomyAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    protected Class<TaxonomySPI> getSpiType() {
        return TaxonomySPI.class;
    }

    @Override
    public Map<String, Taxonomy> list(Context context, String postType) {
        return ((TaxonomySPI)this.getSpi()).list(this.getApiVersion(), context, postType);
    }

    @Override
    public Taxonomy retrieve(Context context, String taxonomy) {
        Preconditions.checkNotNull(Strings.emptyToNull(taxonomy), "Please define a taxonomy");
        return ((TaxonomySPI)this.getSpi()).retrieve(this.getApiVersion(), context, taxonomy);
    }
}

