/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.model.PostRevision;
import org.apache.camel.component.wordpress.api.service.WordpressServicePostRevision;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressServiceAdapter;
import org.apache.camel.component.wordpress.api.service.spi.PostRevisionsSPI;

public class WordpressSevicePostRevisionAdapter
extends AbstractWordpressServiceAdapter<PostRevisionsSPI>
implements WordpressServicePostRevision {
    public WordpressSevicePostRevisionAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    protected Class<PostRevisionsSPI> getSpiType() {
        return PostRevisionsSPI.class;
    }

    @Override
    public void delete(Integer postId, Integer revisionId) {
        Preconditions.checkArgument(postId > 0, "Please define a post id");
        Preconditions.checkArgument(revisionId > 0, "Please define a revision id");
        ((PostRevisionsSPI)this.getSpi()).delete(this.getApiVersion(), postId, revisionId);
    }

    @Override
    public PostRevision retrieve(Integer postId, Integer revisionId, Context context) {
        Preconditions.checkArgument(postId > 0, "Please define a post id");
        Preconditions.checkArgument(revisionId > 0, "Please define a revision id");
        return ((PostRevisionsSPI)this.getSpi()).retrieveRevision(this.getApiVersion(), postId, revisionId, context);
    }

    @Override
    public List<PostRevision> list(Integer postId, Context context) {
        Preconditions.checkArgument(postId > 0, "Please define a post id");
        return ((PostRevisionsSPI)this.getSpi()).list(this.getApiVersion(), postId, context);
    }
}

