/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.component.wordpress.api.WordpressServiceProvider;
import org.apache.camel.component.wordpress.api.model.Post;
import org.apache.camel.component.wordpress.api.service.WordpressServicePosts;
import org.apache.camel.component.wordpress.producer.AbstractWordpressProducer;

public class WordpressPostProducer
extends AbstractWordpressProducer<Post> {
    private WordpressServicePosts servicePosts = WordpressServiceProvider.getInstance().getService(WordpressServicePosts.class);

    public WordpressPostProducer(WordpressEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected Post processInsert(Exchange exchange) {
        LOG.debug("Trying to create a new blog post with {}", exchange.getIn().getBody());
        return this.servicePosts.create(exchange.getIn().getBody(Post.class));
    }

    @Override
    protected Post processUpdate(Exchange exchange) {
        LOG.debug("Trying to update the post {} with id {}", exchange.getIn().getBody(), (Object)this.getConfiguration().getId());
        return this.servicePosts.update(this.getConfiguration().getId(), exchange.getIn().getBody(Post.class));
    }

    @Override
    protected Post processDelete(Exchange exchange) {
        LOG.debug("Trying to delete a post with id {}", (Object)this.getConfiguration().getId());
        if (this.getConfiguration().isForce()) {
            return (Post)this.servicePosts.forceDelete(this.getConfiguration().getId()).getPrevious();
        }
        return (Post)this.servicePosts.delete(this.getConfiguration().getId());
    }
}

