/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.AbstractLoggingInterceptor;
import org.apache.cxf.ext.logging.WireTapIn;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrintWriterEventSender;
import org.apache.cxf.ext.logging.slf4j.Slf4jVerboseEventSender;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;

@NoJSR250Annotations
public class LoggingInInterceptor
extends AbstractLoggingInterceptor {
    public LoggingInInterceptor() {
        this(new Slf4jVerboseEventSender());
    }

    public LoggingInInterceptor(PrintWriter writer) {
        this(new PrintWriterEventSender(writer));
    }

    public LoggingInInterceptor(LogEventSender sender) {
        super("pre-invoke", sender);
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        ArrayList<PhaseInterceptor<? extends Message>> ret = new ArrayList<PhaseInterceptor<? extends Message>>();
        ret.add(new WireTapIn(this.getWireTapLimit(), this.threshold));
        ret.add(new LoggingInFaultInterceptor());
        return ret;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        if (LoggingInInterceptor.isLoggingDisabledNow(message)) {
            return;
        }
        message.put("org.apache.cxf.logging.enable", Boolean.FALSE);
        this.createExchangeId(message);
        LogEvent event = this.eventMapper.map(message, this.sensitiveProtocolHeaderNames);
        if (this.shouldLogContent(event)) {
            this.addContent(message, event);
        } else {
            event.setPayload("--- Content suppressed ---");
        }
        String maskedContent = this.maskSensitiveElements(message, event.getPayload());
        if (!this.logBinary) {
            maskedContent = this.stripBinaryParts(event, maskedContent);
        }
        event.setPayload(this.transform(message, maskedContent));
        this.sender.send(event);
    }

    private void addContent(Message message, LogEvent event) {
        try {
            CachedOutputStream cos = message.getContent(CachedOutputStream.class);
            if (cos != null) {
                this.handleOutputStream(event, message, cos);
            } else {
                CachedWriter writer = message.getContent(CachedWriter.class);
                if (writer != null) {
                    this.handleWriter(event, writer);
                }
            }
        }
        catch (IOException e) {
            throw new Fault(e);
        }
    }

    private void handleOutputStream(LogEvent event, Message message, CachedOutputStream cos) throws IOException {
        String encoding = (String)message.get(Message.ENCODING);
        if (StringUtils.isEmpty(encoding)) {
            encoding = StandardCharsets.UTF_8.name();
        }
        StringBuilder payload = new StringBuilder();
        cos.writeCacheTo(payload, encoding, this.limit);
        cos.close();
        event.setPayload(payload.toString());
        boolean isTruncated = cos.size() > (long)this.limit && this.limit != -1;
        event.setTruncated(isTruncated);
        event.setFullContentFile(cos.getTempFile());
    }

    private void handleWriter(LogEvent event, CachedWriter writer) throws IOException {
        boolean isTruncated = writer.size() > (long)this.limit && this.limit != -1;
        StringBuilder payload = new StringBuilder();
        writer.writeCacheTo(payload, this.limit);
        writer.close();
        event.setPayload(payload.toString());
        event.setTruncated(isTruncated);
        event.setFullContentFile(writer.getTempFile());
    }

    int getWireTapLimit() {
        if (this.limit == -1) {
            return -1;
        }
        if (this.limit == Integer.MAX_VALUE) {
            return this.limit;
        }
        return this.limit + 1;
    }

    class LoggingInFaultInterceptor
    extends AbstractPhaseInterceptor<Message> {
        LoggingInFaultInterceptor() {
            super("receive");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
        }

        @Override
        public void handleFault(Message message) throws Fault {
            LoggingInInterceptor.this.handleMessage(message);
        }
    }
}

