/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="workday")
public class WorkdayComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        WorkdayConfiguration configuration = new WorkdayConfiguration();
        configuration = this.parseConfiguration(configuration, remaining, parameters);
        WorkdayEndpoint endpoint = new WorkdayEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    @Override
    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        WorkdayEndpoint workdayEndpoint = (WorkdayEndpoint)endpoint;
        WorkdayConfiguration workdayConfiguration = workdayEndpoint.getWorkdayConfiguration();
        this.validateConnectionParameters(workdayConfiguration);
    }

    protected WorkdayConfiguration parseConfiguration(WorkdayConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        configuration.parseURI(remaining, parameters);
        return configuration;
    }

    protected void validateConnectionParameters(WorkdayConfiguration workdayConfiguration) {
        ObjectHelper.notNull(workdayConfiguration.getHost(), "Host");
        ObjectHelper.notNull(workdayConfiguration.getTenant(), "Tenant");
        ObjectHelper.notNull(workdayConfiguration.getClientId(), "ClientId");
        ObjectHelper.notNull(workdayConfiguration.getClientSecret(), "ClientSecret");
        ObjectHelper.notNull(workdayConfiguration.getTokenRefresh(), "TokenRefresh");
    }
}

