/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday;

import org.apache.camel.CamelContext;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class WorkdayEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        WorkdayEndpoint target = (WorkdayEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "clientid": 
            case "clientId": {
                target.getWorkdayConfiguration().setClientId(WorkdayEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                target.getWorkdayConfiguration().setClientSecret(WorkdayEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "host": {
                target.getWorkdayConfiguration().setHost(WorkdayEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpconnectionmanager": 
            case "httpConnectionManager": {
                target.getWorkdayConfiguration().setHttpConnectionManager(WorkdayEndpointConfigurer.property(camelContext, PoolingHttpClientConnectionManager.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(WorkdayEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "reportformat": 
            case "reportFormat": {
                target.getWorkdayConfiguration().setReportFormat(WorkdayEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "tenant": {
                target.getWorkdayConfiguration().setTenant(WorkdayEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "tokenrefresh": 
            case "tokenRefresh": {
                target.getWorkdayConfiguration().setTokenRefresh(WorkdayEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "clientsecret": 
            case "clientSecret": {
                return String.class;
            }
            case "host": {
                return String.class;
            }
            case "httpconnectionmanager": 
            case "httpConnectionManager": {
                return PoolingHttpClientConnectionManager.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "reportformat": 
            case "reportFormat": {
                return String.class;
            }
            case "tenant": {
                return String.class;
            }
            case "tokenrefresh": 
            case "tokenRefresh": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        WorkdayEndpoint target = (WorkdayEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "clientid": 
            case "clientId": {
                return target.getWorkdayConfiguration().getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return target.getWorkdayConfiguration().getClientSecret();
            }
            case "host": {
                return target.getWorkdayConfiguration().getHost();
            }
            case "httpconnectionmanager": 
            case "httpConnectionManager": {
                return target.getWorkdayConfiguration().getHttpConnectionManager();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "reportformat": 
            case "reportFormat": {
                return target.getWorkdayConfiguration().getReportFormat();
            }
            case "tenant": {
                return target.getWorkdayConfiguration().getTenant();
            }
            case "tokenrefresh": 
            case "tokenRefresh": {
                return target.getWorkdayConfiguration().getTokenRefresh();
            }
        }
        return null;
    }
}

