/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday.auth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.auth.AutheticationClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class AuthClientForIntegration
implements AutheticationClient {
    public static final String BASE_TOKEN_ENDPOINT = "https://%s/ccx/oauth2/%s/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private WorkdayConfiguration workdayConfiguration;

    public AuthClientForIntegration(WorkdayConfiguration workdayConfiguration) {
        this.workdayConfiguration = workdayConfiguration;
    }

    @Override
    public void configure(CloseableHttpClient httpClient, HttpRequestBase method) throws IOException {
        String bearerToken = this.getBearerToken(httpClient);
        method.addHeader(AUTHORIZATION_HEADER, "Bearer " + bearerToken);
    }

    protected String getBearerToken(CloseableHttpClient httpClient) throws IOException {
        String tokenUrl = String.format(BASE_TOKEN_ENDPOINT, this.workdayConfiguration.getHost(), this.workdayConfiguration.getTenant());
        HttpPost httpPost = this.createPostMethod(tokenUrl);
        CloseableHttpResponse httpResponse = httpClient.execute(httpPost);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new IllegalStateException("Got the invalid http status value '" + httpResponse.getStatusLine() + "' as the result of the Token Request '" + tokenUrl + "'");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        httpResponse.getEntity().writeTo(baos);
        return this.parseResponse(baos.toString());
    }

    private HttpPost createPostMethod(String tokenUrl) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair(GRANT_TYPE, REFRESH_TOKEN));
        nvps.add(new BasicNameValuePair(REFRESH_TOKEN, this.workdayConfiguration.getTokenRefresh()));
        HttpPost postMethod = new HttpPost(tokenUrl);
        postMethod.addHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE);
        postMethod.addHeader(AUTHORIZATION_HEADER, "Basic " + new String(Base64.getEncoder().encode((this.workdayConfiguration.getClientId() + ":" + this.workdayConfiguration.getClientSecret()).getBytes())));
        postMethod.setEntity(new UrlEncodedFormEntity(nvps, "UTF-8"));
        return postMethod;
    }

    private String parseResponse(String response) {
        int tokenIdx = response.indexOf(ACCESS_TOKEN);
        if (tokenIdx < 1) {
            throw new IllegalStateException("No valid access token response.");
        }
        response = response.substring(response.indexOf(ACCESS_TOKEN) + 16, response.length() - 3);
        return response;
    }
}

