/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class InMemoryBulkheadRegistry
extends AbstractRegistry<Bulkhead, BulkheadConfig>
implements BulkheadRegistry {
    public InMemoryBulkheadRegistry() {
        this(BulkheadConfig.ofDefaults());
    }

    public InMemoryBulkheadRegistry(io.vavr.collection.Map<String, String> tags) {
        this(BulkheadConfig.ofDefaults(), tags);
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs) {
        this(configs, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", BulkheadConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs, RegistryEventConsumer<Bulkhead> registryEventConsumer) {
        this(configs, registryEventConsumer, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs, RegistryEventConsumer<Bulkhead> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", BulkheadConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers) {
        this(configs, registryEventConsumers, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", BulkheadConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig) {
        super(defaultConfig);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, tags);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers) {
        super(defaultConfig, registryEventConsumers);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumers, tags);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig, RegistryEventConsumer<Bulkhead> registryEventConsumer) {
        super(defaultConfig, registryEventConsumer);
    }

    public InMemoryBulkheadRegistry(BulkheadConfig defaultConfig, RegistryEventConsumer<Bulkhead> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryBulkheadRegistry(Map<String, BulkheadConfig> configs, List<RegistryEventConsumer<Bulkhead>> registryEventConsumers, io.vavr.collection.Map<String, String> tags, RegistryStore<Bulkhead> registryStore) {
        super(configs.getOrDefault("default", BulkheadConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(HashMap.empty()), Optional.ofNullable(registryStore).orElse(new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    @Override
    public Seq<Bulkhead> getAllBulkheads() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public Bulkhead bulkhead(String name) {
        return this.bulkhead(name, HashMap.empty());
    }

    @Override
    public Bulkhead bulkhead(String name, io.vavr.collection.Map<String, String> tags) {
        return this.bulkhead(name, (BulkheadConfig)this.getDefaultConfig(), this.getAllTags(tags));
    }

    @Override
    public Bulkhead bulkhead(String name, BulkheadConfig config) {
        return this.bulkhead(name, config, HashMap.empty());
    }

    @Override
    public Bulkhead bulkhead(String name, BulkheadConfig config, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> Bulkhead.of(name, Objects.requireNonNull(config, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public Bulkhead bulkhead(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier) {
        return this.bulkhead(name, bulkheadConfigSupplier, HashMap.empty());
    }

    @Override
    public Bulkhead bulkhead(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> Bulkhead.of(name, Objects.requireNonNull((BulkheadConfig)Objects.requireNonNull(bulkheadConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public Bulkhead bulkhead(String name, String configName) {
        return this.bulkhead(name, configName, HashMap.empty());
    }

    @Override
    public Bulkhead bulkhead(String name, String configName, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> Bulkhead.of(name, (BulkheadConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), this.getAllTags(tags)));
    }
}

