/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class InMemoryTimeLimiterRegistry
extends AbstractRegistry<TimeLimiter, TimeLimiterConfig>
implements TimeLimiterRegistry {
    public InMemoryTimeLimiterRegistry() {
        this(TimeLimiterConfig.ofDefaults(), (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryTimeLimiterRegistry(io.vavr.collection.Map<String, String> tags) {
        this(TimeLimiterConfig.ofDefaults(), tags);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, RegistryEventConsumer<TimeLimiter> registryEventConsumer) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, RegistryEventConsumer<TimeLimiter> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig) {
        super(defaultConfig);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, tags);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, RegistryEventConsumer<TimeLimiter> registryEventConsumer) {
        super(defaultConfig, registryEventConsumer);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, RegistryEventConsumer<TimeLimiter> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers) {
        super(defaultConfig, registryEventConsumers);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumers, tags);
    }

    @Override
    public Seq<TimeLimiter> getAllTimeLimiters() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public TimeLimiter timeLimiter(String name) {
        return this.timeLimiter(name, (TimeLimiterConfig)this.getDefaultConfig(), HashMap.empty());
    }

    @Override
    public TimeLimiter timeLimiter(String name, io.vavr.collection.Map<String, String> tags) {
        return this.timeLimiter(name, (TimeLimiterConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public TimeLimiter timeLimiter(String name, TimeLimiterConfig config) {
        return this.timeLimiter(name, config, HashMap.empty());
    }

    @Override
    public TimeLimiter timeLimiter(String name, TimeLimiterConfig timeLimiterConfig, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> TimeLimiter.of(name, Objects.requireNonNull(timeLimiterConfig, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public TimeLimiter timeLimiter(String name, Supplier<TimeLimiterConfig> timeLimiterConfigSupplier) {
        return this.timeLimiter(name, timeLimiterConfigSupplier, HashMap.empty());
    }

    @Override
    public TimeLimiter timeLimiter(String name, Supplier<TimeLimiterConfig> timeLimiterConfigSupplier, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> TimeLimiter.of(name, Objects.requireNonNull((TimeLimiterConfig)Objects.requireNonNull(timeLimiterConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public TimeLimiter timeLimiter(String name, String configName) {
        return this.timeLimiter(name, configName, HashMap.empty());
    }

    @Override
    public TimeLimiter timeLimiter(String name, String configName, io.vavr.collection.Map<String, String> tags) {
        TimeLimiterConfig config = (TimeLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName));
        return this.timeLimiter(name, config, tags);
    }
}

