/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xchange.XChange;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.component.xchange.XChangeHelper;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.utils.Assert;

@Component(value="xchange")
public class XChangeComponent
extends DefaultComponent {
    private final Map<String, XChange> xchanges = new HashMap<String, XChange>();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XChangeConfiguration configuration = new XChangeConfiguration();
        configuration.setName(remaining);
        XChangeEndpoint endpoint = new XChangeEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        XChange xchange = this.getOrCreateXChange(remaining);
        endpoint.setXchange(xchange);
        return endpoint;
    }

    public XChange getXChange(String name) {
        return this.xchanges.get(name);
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.xchanges.clear();
    }

    private synchronized XChange getOrCreateXChange(String name) {
        XChange xchange = this.xchanges.get(name);
        if (xchange == null) {
            Class<? extends Exchange> exchangeClass = XChangeHelper.loadXChangeClass(this.getCamelContext(), name);
            Assert.notNull(exchangeClass, "XChange not supported: " + name);
            xchange = new XChange(ExchangeFactory.INSTANCE.createExchange(exchangeClass));
            this.xchanges.put(name, xchange);
        }
        return xchange;
    }
}

