/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.Assert;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

public final class BinancePrice
implements Comparable<BinancePrice> {
    private final CurrencyPair pair;
    private final BigDecimal price;

    public BinancePrice(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="price") BigDecimal price) {
        this(CurrencyPairDeserializer.getCurrencyPairFromString(symbol), price);
    }

    public BinancePrice(CurrencyPair pair, BigDecimal price) {
        Assert.notNull(price, "Null price");
        Assert.notNull(pair, "Null pair");
        this.pair = pair;
        this.price = price;
    }

    public CurrencyPair getCurrencyPair() {
        return this.pair;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    @Override
    public int compareTo(BinancePrice o) {
        if (this.pair.compareTo(o.pair) == 0) {
            return this.price.compareTo(o.price);
        }
        return this.pair.compareTo(o.pair);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.pair == null ? 0 : this.pair.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BinancePrice)) {
            return false;
        }
        BinancePrice other = (BinancePrice)obj;
        return this.pair.equals(other.pair) && this.price.equals(other.price);
    }

    public String toString() {
        return "[" + this.pair + "] => " + this.price;
    }
}

