/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.marketdata.BinanceAggTrades;
import org.knowm.xchange.binance.dto.marketdata.BinanceOrderbook;
import org.knowm.xchange.binance.dto.marketdata.BinancePriceQuantity;
import org.knowm.xchange.binance.dto.marketdata.BinanceTicker24h;
import org.knowm.xchange.binance.service.BinanceMarketDataServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.Params;

public class BinanceMarketDataService
extends BinanceMarketDataServiceRaw
implements MarketDataService {
    public BinanceMarketDataService(BinanceExchange exchange, BinanceAuthenticated binance, ResilienceRegistries resilienceRegistries) {
        super(exchange, binance, resilienceRegistries);
    }

    @Override
    public OrderBook getOrderBook(CurrencyPair pair, Object ... args) throws IOException {
        try {
            int limitDepth = 100;
            if (args != null && args.length == 1) {
                Object arg0 = args[0];
                if (!(arg0 instanceof Integer)) {
                    throw new ExchangeException("Argument 0 must be an Integer!");
                }
                limitDepth = (Integer)arg0;
            }
            BinanceOrderbook binanceOrderbook = this.getBinanceOrderbook(pair, limitDepth);
            return BinanceMarketDataService.convertOrderBook(binanceOrderbook, pair);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public static OrderBook convertOrderBook(BinanceOrderbook ob, CurrencyPair pair) {
        List<LimitOrder> bids = ob.bids.entrySet().stream().map(e -> new LimitOrder(Order.OrderType.BID, (BigDecimal)e.getValue(), pair, null, null, (BigDecimal)e.getKey())).collect(Collectors.toList());
        List<LimitOrder> asks = ob.asks.entrySet().stream().map(e -> new LimitOrder(Order.OrderType.ASK, (BigDecimal)e.getValue(), pair, null, null, (BigDecimal)e.getKey())).collect(Collectors.toList());
        return new OrderBook(null, asks, bids);
    }

    @Override
    public Ticker getTicker(CurrencyPair pair, Object ... args) throws IOException {
        try {
            return this.ticker24h(pair).toTicker();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    @Override
    public List<Ticker> getTickers(Params params) throws IOException {
        try {
            return this.ticker24h().stream().map(BinanceTicker24h::toTicker).collect(Collectors.toList());
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    @Override
    public Trades getTrades(CurrencyPair pair, Object ... args) throws IOException {
        try {
            Long fromId = this.tradesArgument(args, 0, Long::valueOf);
            Long startTime = this.tradesArgument(args, 1, Long::valueOf);
            Long endTime = this.tradesArgument(args, 2, Long::valueOf);
            Integer limit = this.tradesArgument(args, 3, Integer::valueOf);
            List<BinanceAggTrades> aggTrades = this.binance.aggTrades(BinanceAdapters.toSymbol(pair), fromId, startTime, endTime, limit);
            List<Trade> trades = aggTrades.stream().map(at -> new Trade.Builder().type(BinanceAdapters.convertType(at.buyerMaker)).originalAmount(at.quantity).currencyPair(pair).price(at.price).timestamp(at.getTimestamp()).id(Long.toString(at.aggregateTradeId)).build()).collect(Collectors.toList());
            return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    private <T extends Number> T tradesArgument(Object[] args, int index, Function<String, T> converter) {
        if (index >= args.length) {
            return null;
        }
        Object arg = args[index];
        if (arg == null) {
            return null;
        }
        String argStr = arg.toString();
        try {
            return (T)((Number)converter.apply(argStr));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Argument on index " + index + " is not a number: " + argStr, e);
        }
    }

    public List<Ticker> getAllBookTickers() throws IOException {
        List<BinancePriceQuantity> binanceTickers = this.tickerAllBookTickers();
        return BinanceAdapters.adaptPriceQuantities(binanceTickers);
    }
}

