/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.currency;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Currency
implements Comparable<Currency>,
Serializable {
    private static final long serialVersionUID = -7340731832345284129L;
    private static final Map<String, Currency> currencies = new HashMap<String, Currency>();
    public static final Currency AED = Currency.createCurrency("AED", "United Arab Emirates Dirham", null, new String[0]);
    public static final Currency AFN = Currency.createCurrency("AFN", "Afghan Afghani", null, new String[0]);
    public static final Currency ALL = Currency.createCurrency("ALL", "Albanian Lek", null, new String[0]);
    public static final Currency AMD = Currency.createCurrency("AMD", "Armenian Dram", null, new String[0]);
    public static final Currency ANC = Currency.createCurrency("ANC", "Anoncoin", null, new String[0]);
    public static final Currency ANG = Currency.createCurrency("ANG", "Netherlands Antillean Guilder", null, new String[0]);
    public static final Currency AOA = Currency.createCurrency("AOA", "Angolan Kwanza", null, new String[0]);
    public static final Currency ARN = Currency.createCurrency("ARN", "Aeron", null, new String[0]);
    public static final Currency ARS = Currency.createCurrency("ARS", "Argentine Peso", null, new String[0]);
    public static final Currency ATOM = Currency.createCurrency("ATOM", "Cosmos", null, new String[0]);
    public static final Currency AUD = Currency.createCurrency("AUD", "Australian Dollar", null, new String[0]);
    public static final Currency AUR = Currency.createCurrency("AUR", "Auroracoin", null, new String[0]);
    public static final Currency AVT = Currency.createCurrency("AVT", "Aventus", null, new String[0]);
    public static final Currency AWG = Currency.createCurrency("AWG", "Aruban Florin", null, new String[0]);
    public static final Currency AZN = Currency.createCurrency("AZN", "Azerbaijani Manat", null, new String[0]);
    public static final Currency BAM = Currency.createCurrency("BAM", "Bosnia-Herzegovina Convertible Mark", null, new String[0]);
    public static final Currency BAT = Currency.createCurrency("BAT", "Basic Attention Token", null, new String[0]);
    public static final Currency BBD = Currency.createCurrency("BBD", "Barbadian Dollar", null, new String[0]);
    public static final Currency BC = Currency.createCurrency("BC", "BlackCoin", null, "BLK");
    public static final Currency BCC = Currency.createCurrency("BCC", "BitConnect", null, new String[0]);
    public static final Currency BCH = Currency.createCurrency("BCH", "BitcoinCash", null, new String[0]);
    public static final Currency BCA = Currency.createCurrency("BCA", "BitcoinAtom", null, new String[0]);
    public static final Currency BLK = Currency.getInstance("BLK");
    public static final Currency BDT = Currency.createCurrency("BDT", "Bangladeshi Taka", null, new String[0]);
    public static final Currency BGC = Currency.createCurrency("BGC", "Aten 'Black Gold' Coin", null, new String[0]);
    public static final Currency BGN = Currency.createCurrency("BGN", "Bulgarian Lev", null, new String[0]);
    public static final Currency BHD = Currency.createCurrency("BHD", "Bahraini Dinar", null, new String[0]);
    public static final Currency BIF = Currency.createCurrency("BIF", "Burundian Franc", null, new String[0]);
    public static final Currency BMD = Currency.createCurrency("BMD", "Bermudan Dollar", null, new String[0]);
    public static final Currency BND = Currency.createCurrency("BND", "Brunei Dollar", null, new String[0]);
    public static final Currency BOB = Currency.createCurrency("BOB", "Bolivian Boliviano", null, new String[0]);
    public static final Currency BRL = Currency.createCurrency("BRL", "Brazilian Real", "R$", new String[0]);
    public static final Currency BRZ = Currency.createCurrency("BRZ", "Brazilian Digital Token", null, new String[0]);
    public static final Currency BSD = Currency.createCurrency("BSD", "Bahamian Dollar", null, new String[0]);
    public static final Currency BTC = Currency.createCurrency("BTC", "Bitcoin", null, "XBT");
    public static final Currency BTG = Currency.createCurrency("BTG", "Bitcoin Gold", null, new String[0]);
    public static final Currency XBT = Currency.getInstance("XBT");
    public static final Currency BTN = Currency.createCurrency("BTN", "Bhutanese Ngultrum", null, new String[0]);
    public static final Currency BWP = Currency.createCurrency("BWP", "Botswanan Pula", null, new String[0]);
    public static final Currency BYR = Currency.createCurrency("BYR", "Belarusian Ruble", null, new String[0]);
    public static final Currency BZD = Currency.createCurrency("BZD", "Belize Dollar", null, new String[0]);
    public static final Currency CAD = Currency.createCurrency("CAD", "Canadian Dollar", null, new String[0]);
    public static final Currency CDF = Currency.createCurrency("CDF", "Congolese Franc", null, new String[0]);
    public static final Currency CHF = Currency.createCurrency("CHF", "Swiss Franc", null, new String[0]);
    public static final Currency CLF = Currency.createCurrency("CLF", "Chilean Unit of Account (UF)", null, new String[0]);
    public static final Currency CLP = Currency.createCurrency("CLP", "Chilean Peso", null, new String[0]);
    public static final Currency CNC = Currency.createCurrency("CNC", "Chinacoin", null, new String[0]);
    public static final Currency CNY = Currency.createCurrency("CNY", "Chinese Yuan", null, new String[0]);
    public static final Currency COP = Currency.createCurrency("COP", "Colombian Peso", null, new String[0]);
    public static final Currency CRC = Currency.createCurrency("CRC", "Costa Rican Col\u00f3n", null, new String[0]);
    public static final Currency CUP = Currency.createCurrency("CUP", "Cuban Peso", null, new String[0]);
    public static final Currency CVE = Currency.createCurrency("CVE", "Cape Verdean Escudo", null, new String[0]);
    public static final Currency CZK = Currency.createCurrency("CZK", "Czech Republic Koruna", null, new String[0]);
    public static final Currency DASH = Currency.createCurrency("DASH", "Dash", null, new String[0]);
    public static final Currency DCR = Currency.createCurrency("DCR", "Decred", null, new String[0]);
    public static final Currency DGB = Currency.createCurrency("DGB", "DigiByte", null, new String[0]);
    public static final Currency DJF = Currency.createCurrency("DJF", "Djiboutian Franc", null, new String[0]);
    public static final Currency DKK = Currency.createCurrency("DKK", "Danish Krone", null, new String[0]);
    public static final Currency DOGE = Currency.createCurrency("DOGE", "Dogecoin", null, "XDG");
    public static final Currency XDG = Currency.getInstance("XDG");
    public static final Currency XDC = Currency.createCurrency("XDC", "XinFin Network", null, new String[0]);
    public static final Currency DOP = Currency.createCurrency("DOP", "Dominican Peso", null, new String[0]);
    public static final Currency DGC = Currency.createCurrency("DGC", "Digitalcoin", null, new String[0]);
    public static final Currency DVC = Currency.createCurrency("DVC", "Devcoin", null, new String[0]);
    public static final Currency DRK = Currency.createCurrency("DRK", "Darkcoin", null, new String[0]);
    public static final Currency DZD = Currency.createCurrency("DZD", "Algerian Dinar", null, new String[0]);
    public static final Currency EDO = Currency.createCurrency("EDO", "Eidoo", null, new String[0]);
    public static final Currency EEK = Currency.createCurrency("EEK", "Estonian Kroon", null, new String[0]);
    public static final Currency EGD = Currency.createCurrency("EGD", "egoldcoin", null, new String[0]);
    public static final Currency EGP = Currency.createCurrency("EGP", "Egyptian Pound", null, new String[0]);
    public static final Currency EOS = Currency.createCurrency("EOS", "EOS", null, new String[0]);
    public static final Currency ETB = Currency.createCurrency("ETB", "Ethiopian Birr", null, new String[0]);
    public static final Currency ETC = Currency.createCurrency("ETC", "Ether Classic", null, new String[0]);
    public static final Currency ETH = Currency.createCurrency("ETH", "Ether", null, new String[0]);
    public static final Currency EUR = Currency.createCurrency("EUR", "Euro", null, new String[0]);
    public static final Currency FJD = Currency.createCurrency("FJD", "Fijian Dollar", null, new String[0]);
    public static final Currency _1ST = Currency.createCurrency("1ST", "First Blood", null, new String[0]);
    public static final Currency FKP = Currency.createCurrency("FKP", "Falkland Islands Pound", null, new String[0]);
    public static final Currency FTC = Currency.createCurrency("FTC", "Feathercoin", null, new String[0]);
    public static final Currency GBP = Currency.createCurrency("GBP", "British Pound Sterling", null, new String[0]);
    public static final Currency GEL = Currency.createCurrency("GEL", "Georgian Lari", null, new String[0]);
    public static final Currency GHS = Currency.createCurrency("GHS", "Ghanaian Cedi", null, new String[0]);
    public static final Currency GHs = Currency.createCurrency("GHS", "Gigahashes per second", null, new String[0]);
    public static final Currency GIP = Currency.createCurrency("GIP", "Gibraltar Pound", null, new String[0]);
    public static final Currency GMD = Currency.createCurrency("GMD", "Gambian Dalasi", null, new String[0]);
    public static final Currency GNF = Currency.createCurrency("GNF", "Guinean Franc", null, new String[0]);
    public static final Currency GNO = Currency.createCurrency("GNO", "Gnosis", null, new String[0]);
    public static final Currency GNT = Currency.createCurrency("GNT", "Golem", null, new String[0]);
    public static final Currency GTQ = Currency.createCurrency("GTQ", "Guatemalan Quetzal", null, new String[0]);
    public static final Currency GVT = Currency.createCurrency("GVT", "Genesis Vision", null, new String[0]);
    public static final Currency GYD = Currency.createCurrency("GYD", "Guyanaese Dollar", null, new String[0]);
    public static final Currency HKD = Currency.createCurrency("HKD", "Hong Kong Dollar", null, new String[0]);
    public static final Currency HVN = Currency.createCurrency("HVN", "Hive", null, new String[0]);
    public static final Currency HNL = Currency.createCurrency("HNL", "Honduran Lempira", null, new String[0]);
    public static final Currency HRK = Currency.createCurrency("HRK", "Croatian Kuna", null, new String[0]);
    public static final Currency HTG = Currency.createCurrency("HTG", "Haitian Gourde", null, new String[0]);
    public static final Currency HUF = Currency.createCurrency("HUF", "Hungarian Forint", null, new String[0]);
    public static final Currency ICN = Currency.createCurrency("ICN", "Iconomi", null, new String[0]);
    public static final Currency IDR = Currency.createCurrency("IDR", "Indonesian Rupiah", null, new String[0]);
    public static final Currency ILS = Currency.createCurrency("ILS", "Israeli New Sheqel", null, new String[0]);
    public static final Currency INR = Currency.createCurrency("INR", "Indian Rupee", null, new String[0]);
    public static final Currency IOC = Currency.createCurrency("IOC", "I/OCoin", null, new String[0]);
    public static final Currency IOT = Currency.createCurrency("IOT", "IOTA", null, new String[0]);
    public static final Currency IQD = Currency.createCurrency("IQD", "Iraqi Dinar", null, new String[0]);
    public static final Currency IRR = Currency.createCurrency("IRR", "Iranian Rial", null, new String[0]);
    public static final Currency ISK = Currency.createCurrency("ISK", "Icelandic Kr\u00f3na", null, new String[0]);
    public static final Currency IXC = Currency.createCurrency("IXC", "iXcoin", null, new String[0]);
    public static final Currency JEP = Currency.createCurrency("JEP", "Jersey Pound", null, new String[0]);
    public static final Currency JMD = Currency.createCurrency("JMD", "Jamaican Dollar", null, new String[0]);
    public static final Currency JOD = Currency.createCurrency("JOD", "Jordanian Dinar", null, new String[0]);
    public static final Currency JPY = Currency.createCurrency("JPY", "Japanese Yen", null, new String[0]);
    public static final Currency KES = Currency.createCurrency("KES", "Kenyan Shilling", null, new String[0]);
    public static final Currency KGS = Currency.createCurrency("KGS", "Kyrgystani Som", null, new String[0]);
    public static final Currency KHR = Currency.createCurrency("KHR", "Cambodian Riel", null, new String[0]);
    public static final Currency KICK = Currency.createCurrency("KICK", "KickCoin", null, new String[0]);
    public static final Currency KMF = Currency.createCurrency("KMF", "Comorian Franc", null, new String[0]);
    public static final Currency KPW = Currency.createCurrency("KPW", "North Korean Won", null, new String[0]);
    public static final Currency KRW = Currency.createCurrency("KRW", "South Korean Won", null, new String[0]);
    public static final Currency KWD = Currency.createCurrency("KWD", "Kuwaiti Dinar", null, new String[0]);
    public static final Currency KYD = Currency.createCurrency("KYD", "Cayman Islands Dollar", null, new String[0]);
    public static final Currency KZT = Currency.createCurrency("KZT", "Kazakhstani Tenge", null, new String[0]);
    public static final Currency LAK = Currency.createCurrency("LAK", "Laotian Kip", null, new String[0]);
    public static final Currency LBP = Currency.createCurrency("LBP", "Lebanese Pound", null, new String[0]);
    public static final Currency LSK = Currency.createCurrency("LSK", "Lisk", null, new String[0]);
    public static final Currency LKR = Currency.createCurrency("LKR", "Sri Lankan Rupee", null, new String[0]);
    public static final Currency LRD = Currency.createCurrency("LRD", "Liberian Dollar", null, new String[0]);
    public static final Currency LSL = Currency.createCurrency("LSL", "Lesotho Loti", null, new String[0]);
    public static final Currency LTC = Currency.createCurrency("LTC", "Litecoin", null, "XLT");
    public static final Currency XLT = Currency.getInstance("XLT");
    public static final Currency LTL = Currency.createCurrency("LTL", "Lithuanian Litas", null, new String[0]);
    public static final Currency LVL = Currency.createCurrency("LVL", "Latvian Lats", null, new String[0]);
    public static final Currency LYD = Currency.createCurrency("LYD", "Libyan Dinar", null, new String[0]);
    public static final Currency MAD = Currency.createCurrency("MAD", "Moroccan Dirham", null, new String[0]);
    public static final Currency MDL = Currency.createCurrency("MDL", "Moldovan Leu", null, new String[0]);
    public static final Currency MEC = Currency.createCurrency("MEC", "MegaCoin", null, new String[0]);
    public static final Currency MGA = Currency.createCurrency("MGA", "Malagasy Ariary", null, new String[0]);
    public static final Currency MKD = Currency.createCurrency("MKD", "Macedonian Denar", null, new String[0]);
    public static final Currency MLN = Currency.createCurrency("MLN", "Melonport", null, new String[0]);
    public static final Currency MMK = Currency.createCurrency("MMK", "Myanma Kyat", null, new String[0]);
    public static final Currency MNT = Currency.createCurrency("MNT", "Mongolian Tugrik", null, new String[0]);
    public static final Currency MOP = Currency.createCurrency("MOP", "Macanese Pataca", null, new String[0]);
    public static final Currency MRO = Currency.createCurrency("MRO", "Mauritanian Ouguiya", null, new String[0]);
    public static final Currency MSC = Currency.createCurrency("MSC", "Mason Coin", null, new String[0]);
    public static final Currency MUR = Currency.createCurrency("MUR", "Mauritian Rupee", null, new String[0]);
    public static final Currency MVR = Currency.createCurrency("MVR", "Maldivian Rufiyaa", null, new String[0]);
    public static final Currency MWK = Currency.createCurrency("MWK", "Malawian Kwacha", null, new String[0]);
    public static final Currency MXN = Currency.createCurrency("MXN", "Mexican Peso", null, new String[0]);
    public static final Currency MYR = Currency.createCurrency("MYR", "Malaysian Ringgit", null, new String[0]);
    public static final Currency MZN = Currency.createCurrency("MZN", "Mozambican Metical", null, new String[0]);
    public static final Currency NAD = Currency.createCurrency("NAD", "Namibian Dollar", null, new String[0]);
    public static final Currency NOBS = Currency.createCurrency("NOBS", "No BS Crypto", null, new String[0]);
    public static final Currency NEO = Currency.createCurrency("NEO", "NEO", null, new String[0]);
    public static final Currency NGN = Currency.createCurrency("NGN", "Nigerian Naira", null, new String[0]);
    public static final Currency NIO = Currency.createCurrency("NIO", "Nicaraguan C\u00f3rdoba", null, new String[0]);
    public static final Currency NMC = Currency.createCurrency("NMC", "Namecoin", null, new String[0]);
    public static final Currency NOK = Currency.createCurrency("NOK", "Norwegian Krone", null, new String[0]);
    public static final Currency NPR = Currency.createCurrency("NPR", "Nepalese Rupee", null, new String[0]);
    public static final Currency NVC = Currency.createCurrency("NVC", "Novacoin", null, new String[0]);
    public static final Currency NXT = Currency.createCurrency("NXT", "Nextcoin", null, new String[0]);
    public static final Currency NZD = Currency.createCurrency("NZD", "New Zealand Dollar", null, new String[0]);
    public static final Currency OMG = Currency.createCurrency("OMG", "OmiseGO", null, new String[0]);
    public static final Currency OMR = Currency.createCurrency("OMR", "Omani Rial", null, new String[0]);
    public static final Currency PAB = Currency.createCurrency("PAB", "Panamanian Balboa", null, new String[0]);
    public static final Currency PEN = Currency.createCurrency("PEN", "Peruvian Sol", null, new String[0]);
    public static final Currency PGK = Currency.createCurrency("PGK", "Papua New Guinean Kina", null, new String[0]);
    public static final Currency PHP = Currency.createCurrency("PHP", "Philippine Peso", null, new String[0]);
    public static final Currency PKR = Currency.createCurrency("PKR", "Pakistani Rupee", null, new String[0]);
    public static final Currency PLN = Currency.createCurrency("PLN", "Polish Zloty", null, new String[0]);
    public static final Currency POT = Currency.createCurrency("POT", "PotCoin", null, new String[0]);
    public static final Currency PPC = Currency.createCurrency("PPC", "Peercoin", null, new String[0]);
    public static final Currency PYG = Currency.createCurrency("PYG", "Paraguayan Guarani", null, new String[0]);
    public static final Currency QAR = Currency.createCurrency("QAR", "Qatari Rial", null, new String[0]);
    public static final Currency QRK = Currency.createCurrency("QRK", "QuarkCoin", null, new String[0]);
    public static final Currency QTUM = Currency.createCurrency("QTUM", "Qtum", null, new String[0]);
    public static final Currency REP = Currency.createCurrency("REP", "Augur", null, new String[0]);
    public static final Currency RON = Currency.createCurrency("RON", "Romanian Leu", null, new String[0]);
    public static final Currency RSD = Currency.createCurrency("RSD", "Serbian Dinar", null, new String[0]);
    public static final Currency RUB = Currency.createCurrency("RUB", "Russian Ruble", null, new String[0]);
    public static final Currency RUR = Currency.createCurrency("RUR", "Old Russian Ruble", null, new String[0]);
    public static final Currency RWF = Currency.createCurrency("RWF", "Rwandan Franc", null, new String[0]);
    public static final Currency SAR = Currency.createCurrency("SAR", "Saudi Riyal", null, new String[0]);
    public static final Currency SBC = Currency.createCurrency("SBC", "Stablecoin", null, new String[0]);
    public static final Currency SBD = Currency.createCurrency("SBD", "Solomon Islands Dollar", null, new String[0]);
    public static final Currency SC = Currency.createCurrency("SC", "Siacoin", null, new String[0]);
    public static final Currency SCR = Currency.createCurrency("SCR", "Seychellois Rupee", null, new String[0]);
    public static final Currency SDG = Currency.createCurrency("SDG", "Sudanese Pound", null, new String[0]);
    public static final Currency SEK = Currency.createCurrency("SEK", "Swedish Krona", null, new String[0]);
    public static final Currency SGD = Currency.createCurrency("SGD", "Singapore Dollar", null, new String[0]);
    public static final Currency SHP = Currency.createCurrency("SHP", "Saint Helena Pound", null, new String[0]);
    public static final Currency SLL = Currency.createCurrency("SLL", "Sierra Leonean Leone", null, new String[0]);
    public static final Currency SMART = Currency.createCurrency("SMART", "SmartCash", null, new String[0]);
    public static final Currency SOS = Currency.createCurrency("SOS", "Somali Shilling", null, new String[0]);
    public static final Currency SRD = Currency.createCurrency("SRD", "Surinamese Dollar", null, new String[0]);
    public static final Currency START = Currency.createCurrency("START", "startcoin", null, new String[0]);
    public static final Currency STEEM = Currency.createCurrency("STEEM", "Steem", null, new String[0]);
    public static final Currency STD = Currency.createCurrency("STD", "S\u00e3o Tom\u00e9 and Pr\u00edncipe Dobra", null, new String[0]);
    public static final Currency STR = Currency.createCurrency("STR", "Stellar", null, new String[0]);
    public static final Currency STRAT = Currency.createCurrency("STRAT", "Stratis", null, new String[0]);
    public static final Currency SVC = Currency.createCurrency("SVC", "Salvadoran Col\u00f3n", null, new String[0]);
    public static final Currency SYP = Currency.createCurrency("SYP", "Syrian Pound", null, new String[0]);
    public static final Currency SZL = Currency.createCurrency("SZL", "Swazi Lilangeni", null, new String[0]);
    public static final Currency THB = Currency.createCurrency("THB", "Thai Baht", null, new String[0]);
    public static final Currency TJS = Currency.createCurrency("TJS", "Tajikistani Somoni", null, new String[0]);
    public static final Currency TMT = Currency.createCurrency("TMT", "Turkmenistani Manat", null, new String[0]);
    public static final Currency TND = Currency.createCurrency("TND", "Tunisian Dinar", null, new String[0]);
    public static final Currency TOP = Currency.createCurrency("TOP", "Tongan Pa\u02bbanga", null, new String[0]);
    public static final Currency TRC = Currency.createCurrency("TRC", "Terracoin", null, new String[0]);
    public static final Currency TRY = Currency.createCurrency("TRY", "Turkish Lira", null, new String[0]);
    public static final Currency TTD = Currency.createCurrency("TTD", "Trinidad and Tobago Dollar", null, new String[0]);
    public static final Currency TWD = Currency.createCurrency("TWD", "New Taiwan Dollar", null, new String[0]);
    public static final Currency TZS = Currency.createCurrency("TZS", "Tanzanian Shilling", null, new String[0]);
    public static final Currency UAH = Currency.createCurrency("UAH", "Ukrainian Hryvnia", null, new String[0]);
    public static final Currency UGX = Currency.createCurrency("UGX", "Ugandan Shilling", null, new String[0]);
    public static final Currency USD = Currency.createCurrency("USD", "United States Dollar", null, new String[0]);
    public static final Currency USDT = Currency.createCurrency("USDT", "Tether USD Anchor", null, new String[0]);
    public static final Currency USDE = Currency.createCurrency("USDE", "Unitary Status Dollar eCoin", null, new String[0]);
    public static final Currency UTC = Currency.createCurrency("UTC", "Ultracoin", null, new String[0]);
    public static final Currency UYU = Currency.createCurrency("UYU", "Uruguayan Peso", null, new String[0]);
    public static final Currency UZS = Currency.createCurrency("UZS", "Uzbekistan Som", null, new String[0]);
    public static final Currency VEF = Currency.createCurrency("VEF", "Venezuelan Bol\u00edvar", null, new String[0]);
    public static final Currency VET = Currency.createCurrency("VET", "Hub Culture's Vet", null, "VEN");
    public static final Currency VEN = Currency.createCurrency("VEN", "Hub Culture's Ven", null, "XVN");
    public static final Currency XTZ = Currency.createCurrency("XTZ", "Tezos", null, new String[0]);
    public static final Currency XVN = Currency.getInstance("XVN");
    public static final Currency VIB = Currency.createCurrency("VIB", "Viberate", null, new String[0]);
    public static final Currency VND = Currency.createCurrency("VND", "Vietnamese Dong", null, new String[0]);
    public static final Currency VUV = Currency.createCurrency("VUV", "Vanuatu Vatu", null, new String[0]);
    public static final Currency WDC = Currency.createCurrency("WDC", "WorldCoin", null, new String[0]);
    public static final Currency WST = Currency.createCurrency("WST", "Samoan Tala", null, new String[0]);
    public static final Currency XAF = Currency.createCurrency("XAF", "CFA Franc BEAC", null, new String[0]);
    public static final Currency XAS = Currency.createCurrency("XAS", "Asch", null, new String[0]);
    public static final Currency XAUR = Currency.createCurrency("XAUR", "Xaurum", null, new String[0]);
    public static final Currency XCD = Currency.createCurrency("XCD", "East Caribbean Dollar", null, new String[0]);
    public static final Currency XDR = Currency.createCurrency("XDR", "Special Drawing Rights", null, new String[0]);
    public static final Currency XEM = Currency.createCurrency("XEM", "NEM", null, new String[0]);
    public static final Currency XLM = Currency.createCurrency("XLM", "Stellar Lumen", null, new String[0]);
    public static final Currency XMR = Currency.createCurrency("XMR", "Monero", null, new String[0]);
    public static final Currency XRB = Currency.createCurrency("XRB", "Rai Blocks", null, new String[0]);
    public static final Currency XOF = Currency.createCurrency("XOF", "CFA Franc BCEAO", null, new String[0]);
    public static final Currency XPF = Currency.createCurrency("XPF", "CFP Franc", null, new String[0]);
    public static final Currency XPM = Currency.createCurrency("XPM", "Primecoin", null, new String[0]);
    public static final Currency XRP = Currency.createCurrency("XRP", "Ripple", null, new String[0]);
    public static final Currency YBC = Currency.createCurrency("YBC", "YbCoin", null, new String[0]);
    public static final Currency YER = Currency.createCurrency("YER", "Yemeni Rial", null, new String[0]);
    public static final Currency ZAR = Currency.createCurrency("ZAR", "South African Rand", null, new String[0]);
    public static final Currency ZEC = Currency.createCurrency("ZEC", "Zcash", null, new String[0]);
    public static final Currency ZEN = Currency.createCurrency("ZEN", "ZenCash", null, new String[0]);
    public static final Currency ZMW = Currency.createCurrency("ZMW", "Zambian Kwacha", null, "ZMK");
    public static final Currency ZMK = Currency.getInstance("ZMK");
    public static final Currency ZRC = Currency.createCurrency("ZRC", "ziftrCOIN", null, new String[0]);
    public static final Currency ZWL = Currency.createCurrency("ZWL", "Zimbabwean Dollar", null, new String[0]);
    public static final Currency H18 = Currency.createCurrency("H18", "March 30th", null, new String[0]);
    public static final Currency M18 = Currency.createCurrency("M18", "June 29th", null, new String[0]);
    public static final Currency U18 = Currency.createCurrency("U18", "September 28th", null, new String[0]);
    public static final Currency Z18 = Currency.createCurrency("Z18", "December 28th", null, new String[0]);
    public static final Currency H19 = Currency.createCurrency("H19", "March 29th", null, new String[0]);
    public static final Currency M19 = Currency.createCurrency("M19", "June 28th", null, new String[0]);
    public static final Currency BNK = Currency.createCurrency("BNK", "Bankera Coin", null, new String[0]);
    public static final Currency BNB = Currency.createCurrency("BNB", "Binance Coin", null, new String[0]);
    public static final Currency QSP = Currency.createCurrency("QSP", "Quantstamp", null, new String[0]);
    public static final Currency IOTA = Currency.createCurrency("IOTA", "Iota", null, new String[0]);
    public static final Currency YOYO = Currency.createCurrency("YOYO", "Yoyow", null, new String[0]);
    public static final Currency BTS = Currency.createCurrency("BTS", "Bitshare", null, new String[0]);
    public static final Currency ICX = Currency.createCurrency("ICX", "Icon", null, new String[0]);
    public static final Currency MCO = Currency.createCurrency("MCO", "Monaco", null, new String[0]);
    public static final Currency CND = Currency.createCurrency("CND", "Cindicator", null, new String[0]);
    public static final Currency XVG = Currency.createCurrency("XVG", "Verge", null, new String[0]);
    public static final Currency POE = Currency.createCurrency("POE", "Po.et", null, new String[0]);
    public static final Currency TRX = Currency.createCurrency("TRX", "Tron", null, new String[0]);
    public static final Currency ADA = Currency.createCurrency("ADA", "Cardano", null, new String[0]);
    public static final Currency FUN = Currency.createCurrency("FUN", "FunFair", null, new String[0]);
    public static final Currency HSR = Currency.createCurrency("HSR", "Hshare", null, new String[0]);
    public static final Currency LEND = Currency.createCurrency("LEND", "ETHLend", null, new String[0]);
    public static final Currency ELF = Currency.createCurrency("ELF", "aelf", null, new String[0]);
    public static final Currency STORJ = Currency.createCurrency("STORJ", "Storj", null, new String[0]);
    public static final Currency MOD = Currency.createCurrency("MOD", "Modum", null, new String[0]);
    public static final Currency DAI = Currency.createCurrency("DAI", "Dai", null, new String[0]);
    public static final Currency WETH = Currency.createCurrency("WETH", "Wrapped Ether", null, new String[0]);
    public static final Currency USDC = Currency.createCurrency("USDC", "USD Coin", null, "UDC");
    public static final Currency PBTC = Currency.createCurrency("PBTC", "dydx BTC Perpetual (Linear)", null, new String[0]);
    public static final Currency PLINK = Currency.createCurrency("PLINK", "dydx Link Perpetual (Linear)", null, new String[0]);
    public static final Currency PUSD = Currency.createCurrency("PUSD", "dydx USD Perpetual (Inverse)", null, new String[0]);
    public static final Currency AE = Currency.createCurrency("AE", "Aeternity", null, new String[0]);
    public static final Currency FET = Currency.createCurrency("FET", "Fetch.ai", null, new String[0]);
    public static final Currency BHT = Currency.createCurrency("BHT", "BHEX Token", null, new String[0]);
    public static final Currency SNX = Currency.createCurrency("SNX", "Synthetix Network Token", null, new String[0]);
    public static final Currency PNT = Currency.createCurrency("PNT", "pNetwork", null, new String[0]);
    public static final Currency WIN = Currency.createCurrency("WIN", "WINk", null, new String[0]);
    public static final Currency ANT = Currency.createCurrency("ANT", "Aragon", null, new String[0]);
    public static final Currency DX = Currency.createCurrency("DX", "DxChain Token", null, new String[0]);
    public static final Currency ZB = Currency.createCurrency("ZB", "ZB Token", null, new String[0]);
    public static final Currency LINK = Currency.createCurrency("LINK", "Chainlink", null, new String[0]);
    public static final Currency BTT = Currency.createCurrency("BTT", "BitTorrent", null, new String[0]);
    public static final Currency AVA = Currency.createCurrency("AVA", "Travala.com", null, new String[0]);
    public static final Currency SYS = Currency.createCurrency("SYS", "Syscoin", null, new String[0]);
    public static final Currency BNT = Currency.createCurrency("BNT", "Bancor", null, new String[0]);
    public static final Currency ERD = Currency.createCurrency("ERD", "Elrond", null, new String[0]);
    public static final Currency SNT = Currency.createCurrency("SNT", "Status", null, new String[0]);
    public static final Currency ONE = Currency.createCurrency("ONE", "Harmony", null, new String[0]);
    public static final Currency HPT = Currency.createCurrency("HPT", "Huobi Pool Token", null, new String[0]);
    public static final Currency NEXO = Currency.createCurrency("NEXO", "Nexo", null, new String[0]);
    public static final Currency FXC = Currency.createCurrency("FXC", "Flexacoin", null, new String[0]);
    public static final Currency TOMO = Currency.createCurrency("TOMO", "TomoChain", null, new String[0]);
    public static final Currency OGN = Currency.createCurrency("OGN", "Origin Protocol", null, new String[0]);
    public static final Currency NPXS = Currency.createCurrency("NPXS", "Pundi X", null, new String[0]);
    public static final Currency MIOTA = Currency.createCurrency("MIOTA", "IOTA", null, new String[0]);
    public static final Currency HEDG = Currency.createCurrency("HEDG", "HedgeTrade", null, new String[0]);
    public static final Currency HYN = Currency.createCurrency("HYN", "Hyperion", null, new String[0]);
    public static final Currency DIVI = Currency.createCurrency("DIVI", "Divi", null, new String[0]);
    public static final Currency AION = Currency.createCurrency("AION", "Aion", null, new String[0]);
    public static final Currency CRO = Currency.createCurrency("CRO", "Crypto.com Coin", null, new String[0]);
    public static final Currency ARK = Currency.createCurrency("ARK", "Ark", null, new String[0]);
    public static final Currency PERL = Currency.createCurrency("PERL", "Perlin", null, new String[0]);
    public static final Currency HT = Currency.createCurrency("HT", "Huobi Token", null, new String[0]);
    public static final Currency FSN = Currency.createCurrency("FSN", "Fusion", null, new String[0]);
    public static final Currency LUNA = Currency.createCurrency("LUNA", "Terra", null, new String[0]);
    public static final Currency MAID = Currency.createCurrency("MAID", "MaidSafeCoin", null, new String[0]);
    public static final Currency TFUEL = Currency.createCurrency("TFUEL", "Theta Fuel", null, new String[0]);
    public static final Currency RLC = Currency.createCurrency("RLC", "iExec RLC", null, new String[0]);
    public static final Currency DRGN = Currency.createCurrency("DRGN", "Dragonchain", null, new String[0]);
    public static final Currency LEO = Currency.createCurrency("LEO", "UNUS SED LEO", null, new String[0]);
    public static final Currency TUSD = Currency.createCurrency("TUSD", "TrueUSD", null, new String[0]);
    public static final Currency KSM = Currency.createCurrency("KSM", "Kusama", null, new String[0]);
    public static final Currency MKR = Currency.createCurrency("MKR", "Maker", null, new String[0]);
    public static final Currency PNK = Currency.createCurrency("PNK", "Kleros", null, new String[0]);
    public static final Currency UBT = Currency.createCurrency("UBT", "Unibright", null, new String[0]);
    public static final Currency GRIN = Currency.createCurrency("GRIN", "Grin", null, new String[0]);
    public static final Currency IPX = Currency.createCurrency("IPX", "Tachyon Protocol", null, new String[0]);
    public static final Currency MANA = Currency.createCurrency("MANA", "Decentraland", null, new String[0]);
    public static final Currency CEL = Currency.createCurrency("CEL", "Celsius", null, new String[0]);
    public static final Currency BAND = Currency.createCurrency("BAND", "Band Protocol", null, new String[0]);
    public static final Currency BCD = Currency.createCurrency("BCD", "Bitcoin Diamond", null, new String[0]);
    public static final Currency NRG = Currency.createCurrency("NRG", "Energi", null, new String[0]);
    public static final Currency LOKI = Currency.createCurrency("LOKI", "Loki", null, new String[0]);
    public static final Currency OCEAN = Currency.createCurrency("OCEAN", "Ocean Protocol", null, new String[0]);
    public static final Currency WAN = Currency.createCurrency("WAN", "Wanchain", null, new String[0]);
    public static final Currency MATIC = Currency.createCurrency("MATIC", "Matic Network", null, new String[0]);
    public static final Currency POWR = Currency.createCurrency("POWR", "Power Ledger", null, new String[0]);
    public static final Currency MX = Currency.createCurrency("MX", "MX Token", null, new String[0]);
    public static final Currency IRIS = Currency.createCurrency("IRIS", "IRISnet", null, new String[0]);
    public static final Currency ANKR = Currency.createCurrency("ANKR", "Ankr", null, new String[0]);
    public static final Currency SEELE = Currency.createCurrency("SEELE", "Seele-N", null, new String[0]);
    public static final Currency WXT = Currency.createCurrency("WXT", "Wirex Token", null, new String[0]);
    public static final Currency RVN = Currency.createCurrency("RVN", "Ravencoin", null, new String[0]);
    public static final Currency KCS = Currency.createCurrency("KCS", "KuCoin Shares", null, new String[0]);
    public static final Currency SERO = Currency.createCurrency("SERO", "Super Zero Protocol", null, new String[0]);
    public static final Currency XNS = Currency.createCurrency("XNS", "Insolar", null, new String[0]);
    public static final Currency ALGO = Currency.createCurrency("ALGO", "Algorand", null, new String[0]);
    public static final Currency REN = Currency.createCurrency("REN", "Ren", null, new String[0]);
    public static final Currency WRX = Currency.createCurrency("WRX", "WazirX", null, new String[0]);
    public static final Currency KMD = Currency.createCurrency("KMD", "Komodo", null, new String[0]);
    public static final Currency RSR = Currency.createCurrency("RSR", "Reserve Rights", null, new String[0]);
    public static final Currency MOF = Currency.createCurrency("MOF", "Molecular Future", null, new String[0]);
    public static final Currency RCN = Currency.createCurrency("RCN", "Ripio Credit Network", null, new String[0]);
    public static final Currency RDD = Currency.createCurrency("RDD", "ReddCoin", null, new String[0]);
    public static final Currency LRC = Currency.createCurrency("LRC", "Loopring", null, new String[0]);
    public static final Currency KAVA = Currency.createCurrency("KAVA", "Kava", null, new String[0]);
    public static final Currency FTM = Currency.createCurrency("FTM", "Fantom", null, new String[0]);
    public static final Currency VLX = Currency.createCurrency("VLX", "Velas", null, new String[0]);
    public static final Currency ENG = Currency.createCurrency("ENG", "Enigma", null, new String[0]);
    public static final Currency UTK = Currency.createCurrency("UTK", "Utrust", null, new String[0]);
    public static final Currency ZIL = Currency.createCurrency("ZIL", "Zilliqa", null, new String[0]);
    public static final Currency TRAC = Currency.createCurrency("TRAC", "OriginTrail", null, new String[0]);
    public static final Currency MTL = Currency.createCurrency("MTL", "Metal", null, new String[0]);
    public static final Currency WAVES = Currency.createCurrency("WAVES", "Waves", null, new String[0]);
    public static final Currency DGTX = Currency.createCurrency("DGTX", "Digitex Futures", null, new String[0]);
    public static final Currency QNT = Currency.createCurrency("QNT", "Quant", null, new String[0]);
    public static final Currency SOL = Currency.createCurrency("SOL", "Solana", null, new String[0]);
    public static final Currency XHV = Currency.createCurrency("XHV", "Haven Protocol", null, new String[0]);
    public static final Currency AMPL = Currency.createCurrency("AMPL", "Ampleforth", null, new String[0]);
    public static final Currency ELA = Currency.createCurrency("ELA", "Elastos", null, new String[0]);
    public static final Currency VTHO = Currency.createCurrency("VTHO", "VeThor Token", null, new String[0]);
    public static final Currency PAXG = Currency.createCurrency("PAXG", "PAX Gold", null, new String[0]);
    public static final Currency MONA = Currency.createCurrency("MONA", "MonaCoin", null, new String[0]);
    public static final Currency CHSB = Currency.createCurrency("CHSB", "SwissBorg", null, new String[0]);
    public static final Currency ENJ = Currency.createCurrency("ENJ", "Enjin Coin", null, new String[0]);
    public static final Currency PAI = Currency.createCurrency("PAI", "Project Pai", null, new String[0]);
    public static final Currency TRUE = Currency.createCurrency("TRUE", "TrueChain", null, new String[0]);
    public static final Currency ARDR = Currency.createCurrency("ARDR", "Ardor", null, new String[0]);
    public static final Currency BTM = Currency.createCurrency("BTM", "Bytom", null, new String[0]);
    public static final Currency STX = Currency.createCurrency("STX", "Blockstack", null, new String[0]);
    public static final Currency XDCE = Currency.createCurrency("XDCE", "XinFin Network", null, new String[0]);
    public static final Currency ETN = Currency.createCurrency("ETN", "Electroneum", null, new String[0]);
    public static final Currency CHZ = Currency.createCurrency("CHZ", "Chiliz", null, new String[0]);
    public static final Currency CTXC = Currency.createCurrency("CTXC", "Cortex", null, new String[0]);
    public static final Currency GT = Currency.createCurrency("GT", "Gatechain Token", null, new String[0]);
    public static final Currency FTT = Currency.createCurrency("FTT", "FTX Token", null, new String[0]);
    public static final Currency CVT = Currency.createCurrency("CVT", "CyberVein", null, new String[0]);
    public static final Currency WTC = Currency.createCurrency("WTC", "Waltonchain", null, new String[0]);
    public static final Currency ORBS = Currency.createCurrency("ORBS", "Orbs", null, new String[0]);
    public static final Currency HIVE = Currency.createCurrency("HIVE", "Hive", null, new String[0]);
    public static final Currency BSV = Currency.createCurrency("BSV", "Bitcoin SV", null, new String[0]);
    public static final Currency PAX = Currency.createCurrency("PAX", "Paxos Standard", null, new String[0]);
    public static final Currency GXC = Currency.createCurrency("GXC", "GXChain", null, new String[0]);
    public static final Currency KNC = Currency.createCurrency("KNC", "Kyber Network", null, new String[0]);
    public static final Currency BUSD = Currency.createCurrency("BUSD", "Binance USD", null, new String[0]);
    public static final Currency CHR = Currency.createCurrency("CHR", "Chromia", null, new String[0]);
    public static final Currency HC = Currency.createCurrency("HC", "HyperCash", null, new String[0]);
    public static final Currency TT = Currency.createCurrency("TT", "Thunder Token", null, new String[0]);
    public static final Currency EURS = Currency.createCurrency("EURS", "STASIS EURO", null, new String[0]);
    public static final Currency HBAR = Currency.createCurrency("HBAR", "Hedera Hashgraph", null, new String[0]);
    public static final Currency ONT = Currency.createCurrency("ONT", "Ontology", null, new String[0]);
    public static final Currency VGX = Currency.createCurrency("VGX", "Voyager Token", null, new String[0]);
    public static final Currency HOT = Currency.createCurrency("HOT", "Holo", null, new String[0]);
    public static final Currency XZC = Currency.createCurrency("XZC", "Zcoin", null, new String[0]);
    public static final Currency CELR = Currency.createCurrency("CELR", "Celer Network", null, new String[0]);
    public static final Currency CKB = Currency.createCurrency("CKB", "Nervos Network", null, new String[0]);
    public static final Currency WICC = Currency.createCurrency("WICC", "WaykiChain", null, new String[0]);
    public static final Currency WAXP = Currency.createCurrency("WAXP", "WAX", null, new String[0]);
    public static final Currency BEAM = Currency.createCurrency("BEAM", "Beam", null, new String[0]);
    public static final Currency SXP = Currency.createCurrency("SXP", "Swipe", null, new String[0]);
    public static final Currency IOTX = Currency.createCurrency("IOTX", "IoTeX", null, new String[0]);
    public static final Currency VSYS = Currency.createCurrency("VSYS", "v.systems", null, new String[0]);
    public static final Currency DATA = Currency.createCurrency("DATA", "Streamr", null, new String[0]);
    public static final Currency NIM = Currency.createCurrency("NIM", "Nimiq", null, new String[0]);
    public static final Currency REQ = Currency.createCurrency("REQ", "Request", null, new String[0]);
    public static final Currency RIF = Currency.createCurrency("RIF", "RSK Infrastructure Framework", null, new String[0]);
    public static final Currency COMP = Currency.createCurrency("COMP", "Compound", null, new String[0]);
    public static final Currency TMTG = Currency.createCurrency("TMTG", "The Midas Touch Gold", null, new String[0]);
    public static final Currency ABBC = Currency.createCurrency("ABBC", "ABBC Coin", null, new String[0]);
    public static final Currency NAS = Currency.createCurrency("NAS", "Nebulas", null, new String[0]);
    public static final Currency NANO = Currency.createCurrency("NANO", "Nano", null, new String[0]);
    public static final Currency NMR = Currency.createCurrency("NMR", "Numeraire", null, new String[0]);
    public static final Currency CRPT = Currency.createCurrency("CRPT", "Crypterium", null, new String[0]);
    public static final Currency DAD = Currency.createCurrency("DAD", "DAD", null, new String[0]);
    public static final Currency MXC = Currency.createCurrency("MXC", "MXC", null, new String[0]);
    public static final Currency TSHP = Currency.createCurrency("TSHP", "12Ships", null, new String[0]);
    public static final Currency IOST = Currency.createCurrency("IOST", "IOST", null, new String[0]);
    public static final Currency THETA = Currency.createCurrency("THETA", "THETA", null, new String[0]);
    public static final Currency HUSD = Currency.createCurrency("HUSD", "HUSD", null, new String[0]);
    public static final Currency COTI = Currency.createCurrency("COTI", "COTI", null, new String[0]);
    public static final Currency PIVX = Currency.createCurrency("PIVX", "PIVX", null, new String[0]);
    public static final Currency NULS = Currency.createCurrency("NULS", "NULS", null, new String[0]);
    public static final Currency SOLVE = Currency.createCurrency("SOLVE", "SOLVE", null, new String[0]);
    public static final Currency OKB = Currency.createCurrency("OKB", "OKB", null, new String[0]);
    public static final Currency ZRX = Currency.createCurrency("ZRX", "0x", null, new String[0]);
    private final String code;
    private final CurrencyAttributes attributes;

    public Currency(String code) {
        this.code = code;
        this.attributes = Currency.getInstance((String)code).attributes;
    }

    private Currency(String alternativeCode, CurrencyAttributes attributes) {
        this.code = alternativeCode;
        this.attributes = attributes;
    }

    public static SortedSet<Currency> getAvailableCurrencies() {
        return new TreeSet<Currency>(currencies.values());
    }

    public static SortedSet<String> getAvailableCurrencyCodes() {
        return new TreeSet<String>(currencies.keySet());
    }

    @JsonCreator
    public static Currency getInstance(String currencyCode) {
        Currency currency = Currency.getInstanceNoCreate(currencyCode.toUpperCase());
        if (currency == null) {
            return Currency.createCurrency(currencyCode.toUpperCase(), null, null, new String[0]);
        }
        return currency;
    }

    public static Currency getInstanceNoCreate(String currencyCode) {
        return currencies.get(currencyCode.toUpperCase());
    }

    private static Currency createCurrency(String commonCode, String name, String unicode, String ... alternativeCodes) {
        CurrencyAttributes attributes = new CurrencyAttributes(commonCode, name, unicode, alternativeCodes);
        Currency currency = new Currency(commonCode, attributes);
        for (String code : attributes.codes) {
            if (commonCode.equals(code)) {
                currencies.put(code, currency);
                continue;
            }
            if (currencies.containsKey(code)) continue;
            currencies.put(code, new Currency(code, attributes));
        }
        return currency;
    }

    @JsonValue
    public String getCurrencyCode() {
        return this.code;
    }

    public Currency getCodeCurrency(String code) {
        if (code.equals(this.code)) {
            return this;
        }
        Currency currency = Currency.getInstance(code);
        if (currency.equals(this)) {
            return currency;
        }
        if (!this.attributes.codes.contains(code)) {
            throw new IllegalArgumentException("Code not listed for this currency");
        }
        return new Currency(code, this.attributes);
    }

    public Currency getIso4217Currency() {
        if (this.attributes.isoCode == null) {
            return this;
        }
        return this.getCodeCurrency(this.attributes.isoCode);
    }

    public Currency getCommonlyUsedCurrency() {
        return this.getCodeCurrency(this.attributes.commonCode);
    }

    public Set<String> getCurrencyCodes() {
        return this.attributes.codes;
    }

    public String getSymbol() {
        return this.attributes.unicode;
    }

    public String getDisplayName() {
        return this.attributes.name;
    }

    public String toString() {
        return this.code;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Currency other = (Currency)obj;
        return this.attributes.equals(other.attributes);
    }

    @Override
    public int compareTo(Currency o) {
        if (this.attributes.equals(o.attributes)) {
            return 0;
        }
        int comparison = this.code.compareTo(o.code);
        if (comparison == 0) {
            comparison = this.getDisplayName().compareTo(o.getDisplayName());
        }
        if (comparison == 0) {
            comparison = this.hashCode() - o.hashCode();
        }
        return comparison;
    }

    private static class CurrencyAttributes
    implements Serializable {
        private static final long serialVersionUID = -5575649542242146958L;
        public final Set<String> codes;
        public final String isoCode;
        public final String commonCode;
        public final String name;
        public final String unicode;

        public CurrencyAttributes(String commonCode, String name, String unicode, String ... alternativeCodes) {
            if (alternativeCodes.length > 0) {
                this.codes = new TreeSet<String>(Arrays.asList(alternativeCodes));
                this.codes.add(commonCode);
            } else {
                this.codes = Collections.singleton(commonCode);
            }
            String possibleIsoProposalCryptoCode = null;
            java.util.Currency javaCurrency = null;
            for (String code : this.codes) {
                if (javaCurrency == null) {
                    try {
                        javaCurrency = java.util.Currency.getInstance(code);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!code.startsWith("X")) continue;
                possibleIsoProposalCryptoCode = code;
            }
            this.isoCode = javaCurrency != null ? javaCurrency.getCurrencyCode() : possibleIsoProposalCryptoCode;
            this.commonCode = commonCode;
            this.name = name != null ? name : (javaCurrency != null ? javaCurrency.getDisplayName() : commonCode);
            this.unicode = unicode != null ? unicode : (javaCurrency != null ? javaCurrency.getSymbol() : commonCode);
        }

        public int hashCode() {
            return this.commonCode.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CurrencyAttributes other = (CurrencyAttributes)obj;
            return !(this.commonCode == null ? other.commonCode != null : !this.commonCode.equals(other.commonCode));
        }
    }
}

