/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.derivative;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.Derivative;
import org.knowm.xchange.instrument.Instrument;

public class FuturesContract
extends Instrument
implements Derivative,
Comparable<FuturesContract>,
Serializable {
    private static final long serialVersionUID = 6876906648149216819L;
    private static final Comparator<FuturesContract> COMPARATOR = Comparator.comparing(FuturesContract::getCurrencyPair).thenComparing(FuturesContract::getPrompt);
    private final CurrencyPair currencyPair;
    private final String prompt;

    public FuturesContract(CurrencyPair currencyPair, String prompt) {
        this.currencyPair = currencyPair;
        this.prompt = prompt;
    }

    @JsonCreator
    public FuturesContract(String symbol) {
        String[] parts = symbol.split("/");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Could not parse futures contract from '" + symbol + "'");
        }
        String base = parts[0];
        String counter = parts[1];
        String prompt = parts[2];
        this.currencyPair = new CurrencyPair(base, counter);
        this.prompt = prompt;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean isPerpetual() {
        return this.prompt.matches("(?i)PERP|SWAP|PERPETUAL");
    }

    @Override
    public int compareTo(FuturesContract that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FuturesContract contract = (FuturesContract)o;
        return Objects.equals(this.currencyPair, contract.currencyPair) && Objects.equals(this.prompt, contract.prompt);
    }

    public int hashCode() {
        return Objects.hash(this.currencyPair, this.prompt);
    }

    @JsonValue
    public String toString() {
        return this.currencyPair + "/" + this.prompt;
    }
}

