/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.currency.Currency;

public final class FundingRecord
implements Serializable {
    private static final long serialVersionUID = 3788398035845873448L;
    private final String address;
    private final String addressTag;
    private final Date date;
    private final Currency currency;
    private final BigDecimal amount;
    private final String internalId;
    private final String blockchainTransactionHash;
    private final Type type;
    private final Status status;
    private final BigDecimal balance;
    private final BigDecimal fee;
    private String description;

    @Deprecated
    public FundingRecord(String address, Date date, Currency currency, BigDecimal amount, String internalId, String blockchainTransactionHash, Type type, String status, BigDecimal balance, BigDecimal fee, String description) {
        this(address, date, currency, amount, internalId, blockchainTransactionHash, type, Status.resolveStatus(status), balance, fee, description);
        if (this.status == null && status != null) {
            this.description = this.description == null || this.description.isEmpty() ? status : status + ": " + this.description;
        }
    }

    public FundingRecord(String address, String addressTag, Date date, Currency currency, BigDecimal amount, String internalId, String blockchainTransactionHash, Type type, Status status, BigDecimal balance, BigDecimal fee, String description) {
        this.address = address;
        this.addressTag = addressTag == null || addressTag.isEmpty() ? null : addressTag;
        this.date = date;
        this.currency = currency;
        this.amount = amount == null ? null : amount.abs();
        this.internalId = internalId;
        this.blockchainTransactionHash = blockchainTransactionHash;
        this.type = type;
        this.status = status;
        this.balance = balance;
        this.fee = fee == null ? null : fee.abs();
        this.description = description;
    }

    public FundingRecord(String address, Date date, Currency currency, BigDecimal amount, String internalId, String blockchainTransactionHash, Type type, Status status, BigDecimal balance, BigDecimal fee, String description) {
        this(address, null, date, currency, amount, internalId, blockchainTransactionHash, type, status, balance, fee, description);
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressTag() {
        return this.addressTag;
    }

    public Date getDate() {
        return this.date;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getInternalId() {
        return this.internalId;
    }

    @Deprecated
    public String getExternalId() {
        return this.blockchainTransactionHash;
    }

    public String getBlockchainTransactionHash() {
        return this.blockchainTransactionHash;
    }

    public Type getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.format("FundingRecord{address='%s', date=%s, currency=%s, amount=%s, internalId=%s, blockchainTransactionHash=%s, description='%s', type=%s, status=%s, balance=%s, fee=%s}", new Object[]{this.address, this.date, this.currency, this.amount, this.internalId, this.blockchainTransactionHash, this.description, this.type, this.status, this.balance, this.fee});
    }

    public static enum Type {
        WITHDRAWAL(false),
        DEPOSIT(true),
        AIRDROP(true),
        OTHER_INFLOW(true),
        OTHER_OUTFLOW(false),
        INTERNAL_WITHDRAWAL(false),
        INTERNAL_DEPOSIT(true),
        REALISED_LOSS(false),
        REALISED_PROFIT(true);

        private static final Map<String, Type> fromString;
        private final boolean inflow;

        private Type(boolean inflow) {
            this.inflow = inflow;
        }

        public static Type fromString(String ledgerTypeString) {
            return fromString.get(ledgerTypeString.toUpperCase());
        }

        public boolean isInflowing() {
            return this.inflow;
        }

        public boolean isOutflowing() {
            return !this.inflow;
        }

        static {
            fromString = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                fromString.put(type.toString(), type);
            }
        }
    }

    public static enum Status {
        PROCESSING("WAIT CONFIRMATION", "EMAIL CONFIRMATION", "EMAIL SENT", "AWAITING APPROVAL", "VERIFYING", "PENDING_APPROVAL", "PENDING"),
        COMPLETE("COMPLETED"),
        CANCELLED("REVOKED", "CANCEL", "REFUND"),
        FAILED("FAILURE");

        private static final Map<String, Status> fromString;
        private String[] statusArray;

        private Status(String ... statusArray) {
            this.statusArray = statusArray;
        }

        public static Status resolveStatus(String str) {
            if (str == null) {
                return null;
            }
            return fromString.get(str.toUpperCase());
        }

        static {
            fromString = new HashMap<String, Status>();
            for (Status status : Status.values()) {
                String[] statusArray = status.statusArray;
                if (statusArray != null) {
                    for (String statusStr : statusArray) {
                        fromString.put(statusStr, status);
                    }
                }
                fromString.put(status.toString(), status);
            }
        }
    }

    public static final class Builder {
        private String address;
        private String addressTag;
        private Date date;
        private Currency currency;
        private BigDecimal amount;
        private String internalId;
        private String blockchainTransactionHash;
        private String description;
        private Type type;
        private Status status;
        private BigDecimal balance;
        private BigDecimal fee;

        public static Builder from(FundingRecord record) {
            return new Builder().setAddress(record.address).setAddressTag(record.addressTag).setBlockchainTransactionHash(record.blockchainTransactionHash).setDate(record.date).setCurrency(record.currency).setAmount(record.amount).setInternalId(record.internalId).setDescription(record.description).setType(record.type).setStatus(record.status).setBalance(record.balance).setFee(record.fee);
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setAddressTag(String addressTag) {
            this.addressTag = addressTag;
            return this;
        }

        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder setAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder setInternalId(String internalId) {
            this.internalId = internalId;
            return this;
        }

        public Builder setBlockchainTransactionHash(String blockchainTransactionHash) {
            this.blockchainTransactionHash = blockchainTransactionHash;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setBalance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        public Builder setFee(BigDecimal fee) {
            this.fee = fee;
            return this;
        }

        public FundingRecord build() {
            return new FundingRecord(this.address, this.addressTag, this.date, this.currency, this.amount, this.internalId, this.blockchainTransactionHash, this.type, this.status, this.balance, this.fee, this.description);
        }
    }
}

