/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import org.knowm.xchange.instrument.Instrument;

public class OpenPosition
implements Serializable {
    private final Instrument instrument;
    private final Type type;
    private final BigDecimal size;
    private final BigDecimal price;

    public OpenPosition(Instrument instrument, Type type, BigDecimal size, BigDecimal price) {
        this.instrument = instrument;
        this.type = type;
        this.size = size;
        this.price = price;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenPosition that = (OpenPosition)o;
        return Objects.equals(this.instrument, that.instrument) && this.type == that.type && Objects.equals(this.size, that.size) && Objects.equals(this.price, that.price);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instrument, this.type, this.size, this.price});
    }

    public String toString() {
        return "OpenPosition{instrument=" + this.instrument + ", type=" + (Object)((Object)this.type) + ", size=" + this.size + ", price=" + this.price + '}';
    }

    public static enum Type {
        LONG,
        SHORT;

    }

    public static class Builder {
        private Instrument instrument;
        private Type type;
        private BigDecimal size;
        private BigDecimal price;

        public static Builder from(OpenPosition openPosition) {
            return new Builder().instrument(openPosition.getInstrument()).type(openPosition.getType()).size(openPosition.getSize()).price(openPosition.getPrice());
        }

        public Builder instrument(Instrument instrument) {
            this.instrument = instrument;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder size(BigDecimal size) {
            this.size = size;
            return this;
        }

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public OpenPosition build() {
            return new OpenPosition(this.instrument, this.type, this.size, this.price);
        }
    }
}

