/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.instrument.Instrument;

@JsonDeserialize(builder=Builder.class)
public class Trade
implements Serializable {
    private static final long serialVersionUID = -4078893146776655648L;
    protected final Order.OrderType type;
    protected final BigDecimal originalAmount;
    protected final Instrument instrument;
    protected final BigDecimal price;
    protected final Date timestamp;
    protected final String id;
    protected final String makerOrderId;
    protected final String takerOrderId;

    public Trade(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, BigDecimal price, Date timestamp, String id, String makerOrderId, String takerOrderId) {
        this.type = type;
        this.originalAmount = originalAmount;
        this.instrument = instrument;
        this.price = price;
        this.timestamp = timestamp;
        this.id = id;
        this.makerOrderId = makerOrderId;
        this.takerOrderId = takerOrderId;
    }

    public Order.OrderType getType() {
        return this.type;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    @Deprecated
    @JsonIgnore
    public CurrencyPair getCurrencyPair() {
        if (this.instrument == null) {
            return null;
        }
        if (!(this.instrument instanceof CurrencyPair)) {
            throw new IllegalStateException("The instrument of this order is not a currency pair: " + this.instrument);
        }
        return (CurrencyPair)this.instrument;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public String getMakerOrderId() {
        return this.makerOrderId;
    }

    public String getTakerOrderId() {
        return this.takerOrderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Trade)o).getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Trade{type=" + (Object)((Object)this.type) + ", originalAmount=" + this.originalAmount + ", instrument=" + this.instrument + ", price=" + this.price + ", timestamp=" + this.timestamp + ", id='" + this.id + '\'' + ", makerOrderId='" + this.makerOrderId + '\'' + ", takerOrderId='" + this.takerOrderId + '\'' + '}';
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        protected Order.OrderType type;
        protected BigDecimal originalAmount;
        protected Instrument instrument;
        protected BigDecimal price;
        protected Date timestamp;
        protected String id;
        protected String makerOrderId;
        protected String takerOrderId;

        public static Builder from(Trade trade) {
            return new Builder().type(trade.getType()).originalAmount(trade.getOriginalAmount()).instrument(trade.getInstrument()).price(trade.getPrice()).timestamp(trade.getTimestamp()).id(trade.getId());
        }

        public Builder type(Order.OrderType type) {
            this.type = type;
            return this;
        }

        public Builder originalAmount(BigDecimal originalAmount) {
            this.originalAmount = originalAmount;
            return this;
        }

        public Builder instrument(Instrument instrument) {
            this.instrument = instrument;
            return this;
        }

        @Deprecated
        public Builder currencyPair(CurrencyPair currencyPair) {
            return this.instrument(currencyPair);
        }

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder makerOrderId(String makerOrderId) {
            this.makerOrderId = makerOrderId;
            return this;
        }

        public Builder takerOrderId(String takerOrderId) {
            this.takerOrderId = takerOrderId;
            return this;
        }

        public Trade build() {
            return new Trade(this.type, this.originalAmount, this.instrument, this.price, this.timestamp, this.id, this.makerOrderId, this.takerOrderId);
        }
    }
}

