/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.meta;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.knowm.xchange.dto.meta.FeeTier;

public class DerivativeMetaData
implements Serializable {
    private static final long serialVersionUID = 1471672854252184985L;
    @JsonProperty(value="trading_fee")
    private final BigDecimal tradingFee;
    @JsonProperty(value="fee_tiers")
    private final FeeTier[] feeTiers;
    @JsonProperty(value="min_amount")
    private final BigDecimal minimumAmount;
    @JsonProperty(value="max_amount")
    private final BigDecimal maximumAmount;
    @JsonProperty(value="amount_scale")
    private final Integer amountScale;
    @JsonProperty(value="price_scale")
    private final Integer priceScale;
    @JsonProperty(value="amount_step_size")
    private final BigDecimal amountStepSize;
    @JsonProperty(value="price_step_size")
    private final BigDecimal priceStepSize;

    public DerivativeMetaData(@JsonProperty(value="trading_fee") BigDecimal tradingFee, @JsonProperty(value="min_amount") BigDecimal minimumAmount, @JsonProperty(value="max_amount") BigDecimal maximumAmount, @JsonProperty(value="amount_scale") Integer amountScale, @JsonProperty(value="price_scale") Integer priceScale, @JsonProperty(value="fee_tiers") FeeTier[] feeTiers, @JsonProperty(value="amount_step_size") BigDecimal amountStepSize, @JsonProperty(value="price_step_size") BigDecimal priceStepSize) {
        this.tradingFee = tradingFee;
        this.minimumAmount = minimumAmount;
        this.maximumAmount = maximumAmount;
        this.amountScale = amountScale;
        this.priceScale = priceScale;
        if (feeTiers != null) {
            Arrays.sort(feeTiers);
        }
        this.feeTiers = feeTiers;
        this.amountStepSize = amountStepSize;
        this.priceStepSize = priceStepSize;
    }

    public BigDecimal getTradingFee() {
        return this.tradingFee;
    }

    public FeeTier[] getFeeTiers() {
        return this.feeTiers;
    }

    public BigDecimal getMinimumAmount() {
        return this.minimumAmount;
    }

    public BigDecimal getMaximumAmount() {
        return this.maximumAmount;
    }

    public Integer getAmountScale() {
        return this.amountScale;
    }

    public Integer getPriceScale() {
        return this.priceScale;
    }

    public BigDecimal getAmountStepSize() {
        return this.amountStepSize;
    }

    public BigDecimal getPriceStepSize() {
        return this.priceStepSize;
    }

    public String toString() {
        return "DerivativeMetaData [tradingFee=" + this.tradingFee + ", minimumAmount=" + this.minimumAmount + ", maximumAmount=" + this.maximumAmount + ", amountScale=" + this.amountScale + ", priceScale=" + this.priceScale + ", amountStepSize=" + this.amountStepSize + ", priceStepSize=" + this.priceStepSize + "]";
    }

    public static final class Builder {
        private BigDecimal tradingFee;
        private FeeTier[] feeTiers;
        private BigDecimal minimumAmount;
        private BigDecimal maximumAmount;
        private Integer amountScale;
        private Integer priceScale;
        private BigDecimal amountStepSize;
        private BigDecimal priceStepSize;

        public Builder tradingFee(BigDecimal val) {
            this.tradingFee = val;
            return this;
        }

        public Builder feeTiers(FeeTier[] val) {
            this.feeTiers = val;
            return this;
        }

        public Builder minimumAmount(BigDecimal val) {
            this.minimumAmount = val;
            return this;
        }

        public Builder maximumAmount(BigDecimal val) {
            this.maximumAmount = val;
            return this;
        }

        public Builder amountScale(Integer val) {
            this.amountScale = val;
            return this;
        }

        public Builder priceScale(Integer val) {
            this.priceScale = val;
            return this;
        }

        public Builder amountStepSize(BigDecimal val) {
            this.amountStepSize = val;
            return this;
        }

        public Builder priceStepSize(BigDecimal val) {
            this.priceStepSize = val;
            return this;
        }

        public DerivativeMetaData build() {
            return new DerivativeMetaData(this.tradingFee, this.minimumAmount, this.maximumAmount, this.amountScale, this.priceScale, this.feeTiers, this.amountStepSize, this.priceStepSize);
        }
    }
}

