/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.derivative.OptionsContract;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.DerivativeMetaData;
import org.knowm.xchange.dto.meta.RateLimit;
import org.knowm.xchange.utils.ObjectMapperHelper;

public class ExchangeMetaData
implements Serializable {
    private static final long serialVersionUID = -1495610469981534977L;
    @JsonProperty(value="currency_pairs")
    private Map<CurrencyPair, CurrencyPairMetaData> currencyPairs;
    @JsonProperty(value="currencies")
    private Map<Currency, CurrencyMetaData> currencies;
    @JsonProperty(value="futures")
    private Map<FuturesContract, DerivativeMetaData> futures;
    @JsonProperty(value="options")
    private Map<OptionsContract, DerivativeMetaData> options;
    @JsonProperty(value="public_rate_limits")
    private RateLimit[] publicRateLimits;
    @JsonProperty(value="private_rate_limits")
    private RateLimit[] privateRateLimits;
    @JsonProperty(value="share_rate_limits")
    private boolean shareRateLimits = true;

    public ExchangeMetaData(Map<CurrencyPair, CurrencyPairMetaData> currencyPairs, Map<Currency, CurrencyMetaData> currency, RateLimit[] publicRateLimits, RateLimit[] privateRateLimits, Boolean shareRateLimits) {
        this(currencyPairs, currency, null, null, publicRateLimits, privateRateLimits, shareRateLimits);
    }

    public ExchangeMetaData(@JsonProperty(value="currency_pairs") Map<CurrencyPair, CurrencyPairMetaData> currencyPairs, @JsonProperty(value="currencies") Map<Currency, CurrencyMetaData> currency, @JsonProperty(value="futures") Map<FuturesContract, DerivativeMetaData> futures, @JsonProperty(value="options") Map<OptionsContract, DerivativeMetaData> options, @JsonProperty(value="public_rate_limits") RateLimit[] publicRateLimits, @JsonProperty(value="private_rate_limits") RateLimit[] privateRateLimits, @JsonProperty(value="share_rate_limits") Boolean shareRateLimits) {
        this.currencyPairs = currencyPairs;
        this.currencies = currency;
        this.futures = futures;
        this.options = options;
        this.publicRateLimits = publicRateLimits;
        this.privateRateLimits = privateRateLimits;
        this.shareRateLimits = shareRateLimits != null ? shareRateLimits : false;
    }

    @JsonIgnore
    public static Long getPollDelayMillis(RateLimit[] rateLimits) {
        if (rateLimits == null || rateLimits.length == 0) {
            return null;
        }
        long result = 0L;
        for (RateLimit rateLimit : rateLimits) {
            result = Math.max(result, rateLimit.getPollDelayMillis());
        }
        return result;
    }

    public Map<CurrencyPair, CurrencyPairMetaData> getCurrencyPairs() {
        return this.currencyPairs;
    }

    public Map<Currency, CurrencyMetaData> getCurrencies() {
        return this.currencies;
    }

    public Map<FuturesContract, DerivativeMetaData> getFutures() {
        return this.futures;
    }

    public Map<OptionsContract, DerivativeMetaData> getOptions() {
        return this.options;
    }

    public RateLimit[] getPublicRateLimits() {
        return this.publicRateLimits;
    }

    public RateLimit[] getPrivateRateLimits() {
        return this.privateRateLimits;
    }

    public boolean isShareRateLimits() {
        return this.shareRateLimits;
    }

    @JsonIgnore
    public String toJSONString() {
        return ObjectMapperHelper.toJSON(this);
    }

    public String toString() {
        return "ExchangeMetaData [currencyPairs=" + this.currencyPairs + ", currencies=" + this.currencies + ", futures=" + this.futures + ", options=" + this.options + ", publicRateLimits=" + Arrays.toString(this.publicRateLimits) + ", privateRateLimits=" + Arrays.toString(this.privateRateLimits) + ", shareRateLimits=" + this.shareRateLimits + "]";
    }
}

