/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMapperHelper {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMapperHelper.class);
    private static final ObjectMapper objectMapperWithIndentation = ObjectMapperHelper.initWithIndentation();
    private static final ObjectMapper objectMapperWithoutIndentation = ObjectMapperHelper.initWithoutIndentation();
    private static final ObjectMapper objectMapperStrict = ObjectMapperHelper.initStrict();

    private ObjectMapperHelper() {
    }

    public static <T> T readValue(URL src, Class<T> valueType) throws IOException {
        try (InputStream inputStream = src.openStream();){
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            T t = objectMapperWithoutIndentation.readValue((Reader)reader, valueType);
            return t;
        }
    }

    public static <T> T readValue(String value, Class<T> valueType) throws IOException {
        return objectMapperWithoutIndentation.readValue(value, valueType);
    }

    public static <T> T readValueStrict(String value, Class<T> valueType) throws IOException {
        return objectMapperStrict.readValue(value, valueType);
    }

    public static <T> String toJSON(T valueType) {
        return ObjectMapperHelper.toJSON(objectMapperWithIndentation, valueType);
    }

    public static <T> String toCompactJSON(T valueType) {
        return ObjectMapperHelper.toJSON(objectMapperWithoutIndentation, valueType);
    }

    public static <T> T viaJSON(T valueType) throws IOException {
        String json = ObjectMapperHelper.toJSON(objectMapperStrict, valueType);
        logger.debug("Converted " + valueType + " to " + json);
        return (T)ObjectMapperHelper.readValueStrict(json, valueType.getClass());
    }

    private static <T> String toJSON(ObjectMapper objectMapper, T valueType) {
        try {
            return objectMapper.writeValueAsString(valueType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "Problem serializing " + valueType.getClass();
        }
    }

    private static ObjectMapper initWithIndentation() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).enable(SerializationFeature.INDENT_OUTPUT);
    }

    private static ObjectMapper initWithoutIndentation() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private static ObjectMapper initStrict() {
        return new ObjectMapper();
    }
}

