/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.cache;

import io.github.resilience4j.cache.event.CacheEvent;
import io.github.resilience4j.cache.event.CacheOnErrorEvent;
import io.github.resilience4j.cache.event.CacheOnHitEvent;
import io.github.resilience4j.cache.event.CacheOnMissEvent;
import io.github.resilience4j.cache.internal.CacheImpl;
import io.github.resilience4j.core.EventConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Cache<K, V> {
    public static <K, V> Cache<K, V> of(javax.cache.Cache<K, V> cache) {
        Objects.requireNonNull(cache, "Cache must not be null");
        return new CacheImpl<K, V>(cache);
    }

    public static <K, R> CheckedFunction1<K, R> decorateCheckedSupplier(Cache<K, R> cache, CheckedFunction0<R> supplier) {
        return cacheKey -> cache.computeIfAbsent(cacheKey, supplier);
    }

    public static <K, R> Function<K, R> decorateSupplier(Cache<K, R> cache, Supplier<R> supplier) {
        return cacheKey -> cache.computeIfAbsent(cacheKey, ((Supplier)supplier)::get);
    }

    public static <K, R> CheckedFunction1<K, R> decorateCallable(Cache<K, R> cache, Callable<R> callable) {
        return cacheKey -> cache.computeIfAbsent(cacheKey, callable::call);
    }

    public String getName();

    public Metrics getMetrics();

    public V computeIfAbsent(K var1, CheckedFunction0<V> var2);

    public EventPublisher getEventPublisher();

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<CacheEvent> {
        public EventPublisher onCacheHit(EventConsumer<CacheOnHitEvent> var1);

        public EventPublisher onCacheMiss(EventConsumer<CacheOnMissEvent> var1);

        public EventPublisher onError(EventConsumer<CacheOnErrorEvent> var1);
    }

    public static interface Metrics {
        public long getNumberOfCacheHits();

        public long getNumberOfCacheMisses();
    }
}

