/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.trade.TradeService;
import si.mazi.rescu.SynchronizedValueFactory;

public interface Exchange {
    public static final String USE_SANDBOX = "Use_Sandbox";

    public ExchangeSpecification getExchangeSpecification();

    public ExchangeMetaData getExchangeMetaData();

    public List<CurrencyPair> getExchangeSymbols();

    default public List<Instrument> getExchangeInstruments() {
        return new ArrayList<Instrument>(this.getExchangeSymbols());
    }

    public SynchronizedValueFactory<Long> getNonceFactory();

    default public ResilienceRegistries getResilienceRegistries() {
        throw new NotYetImplementedForExchangeException();
    }

    public ExchangeSpecification getDefaultExchangeSpecification();

    public void applySpecification(ExchangeSpecification var1);

    public MarketDataService getMarketDataService();

    public TradeService getTradeService();

    public AccountService getAccountService();

    public void remoteInit() throws IOException, ExchangeException;
}

