/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceResilience;
import org.knowm.xchange.binance.BinanceTimestampFactory;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.Filter;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.Symbol;
import org.knowm.xchange.binance.service.BinanceAccountService;
import org.knowm.xchange.binance.service.BinanceMarketDataService;
import org.knowm.xchange.binance.service.BinanceTradeService;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.AuthUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceExchange
extends BaseExchange {
    protected static ResilienceRegistries RESILIENCE_REGISTRIES;
    protected BinanceExchangeInfo exchangeInfo;
    protected BinanceAuthenticated binance;
    protected SynchronizedValueFactory<Long> timestampFactory;

    @Override
    protected void initServices() {
        this.binance = ExchangeRestProxyBuilder.forInterface(BinanceAuthenticated.class, this.getExchangeSpecification()).build();
        this.timestampFactory = new BinanceTimestampFactory(this.binance, this.getExchangeSpecification().getResilience(), this.getResilienceRegistries());
        this.marketDataService = new BinanceMarketDataService(this, this.binance, this.getResilienceRegistries());
        this.tradeService = new BinanceTradeService(this, this.binance, this.getResilienceRegistries());
        this.accountService = new BinanceAccountService(this, this.binance, this.getResilienceRegistries());
    }

    public SynchronizedValueFactory<Long> getTimestampFactory() {
        return this.timestampFactory;
    }

    @Override
    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("Binance uses timestamp/recvwindow rather than a nonce");
    }

    public static void resetResilienceRegistries() {
        RESILIENCE_REGISTRIES = null;
    }

    @Override
    public ResilienceRegistries getResilienceRegistries() {
        if (RESILIENCE_REGISTRIES == null) {
            RESILIENCE_REGISTRIES = BinanceResilience.createRegistries();
        }
        return RESILIENCE_REGISTRIES;
    }

    @Override
    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = new ExchangeSpecification(this.getClass());
        spec.setSslUri("https://api.binance.com");
        spec.setHost("www.binance.com");
        spec.setPort(80);
        spec.setExchangeName("Binance");
        spec.setExchangeDescription("Binance Exchange.");
        AuthUtils.setApiAndSecretKey(spec, "binance");
        return spec;
    }

    @Override
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        BinanceExchange.concludeHostParams(exchangeSpecification);
        super.applySpecification(exchangeSpecification);
    }

    public BinanceExchangeInfo getExchangeInfo() {
        return this.exchangeInfo;
    }

    public boolean usingSandbox() {
        return BinanceExchange.enabledSandbox(this.exchangeSpecification);
    }

    @Override
    public void remoteInit() {
        try {
            BinanceMarketDataService marketDataService = (BinanceMarketDataService)this.marketDataService;
            this.exchangeInfo = marketDataService.getExchangeInfo();
            BinanceAccountService accountService = (BinanceAccountService)this.getAccountService();
            Map<String, AssetDetail> assetDetailMap = null;
            if (!this.usingSandbox() && this.isAuthenticated()) {
                assetDetailMap = accountService.getAssetDetails();
            }
            this.postInit(assetDetailMap);
        }
        catch (Exception e) {
            throw new ExchangeException("Failed to initialize: " + e.getMessage(), e);
        }
    }

    protected void postInit(Map<String, AssetDetail> assetDetailMap) {
        Symbol[] symbols;
        Map<CurrencyPair, CurrencyPairMetaData> currencyPairs = this.exchangeMetaData.getCurrencyPairs();
        Map<Currency, CurrencyMetaData> currencies = this.exchangeMetaData.getCurrencies();
        if (assetDetailMap != null) {
            currencies.clear();
        }
        for (Symbol symbol : symbols = this.exchangeInfo.getSymbols()) {
            if (!symbol.getStatus().equals("TRADING")) continue;
            int basePrecision = Integer.parseInt(symbol.getBaseAssetPrecision());
            int counterPrecision = Integer.parseInt(symbol.getQuotePrecision());
            int pairPrecision = 8;
            int amountPrecision = 8;
            BigDecimal minQty = null;
            BigDecimal maxQty = null;
            BigDecimal stepSize = null;
            BigDecimal counterMinQty = null;
            BigDecimal counterMaxQty = null;
            Filter[] filters = symbol.getFilters();
            CurrencyPair currentCurrencyPair = new CurrencyPair(symbol.getBaseAsset(), symbol.getQuoteAsset());
            for (Filter filter : filters) {
                if (filter.getFilterType().equals("PRICE_FILTER")) {
                    pairPrecision = Math.min(pairPrecision, this.numberOfDecimals(filter.getTickSize()));
                    counterMaxQty = new BigDecimal(filter.getMaxPrice()).stripTrailingZeros();
                    continue;
                }
                if (filter.getFilterType().equals("LOT_SIZE")) {
                    amountPrecision = Math.min(amountPrecision, this.numberOfDecimals(filter.getStepSize()));
                    minQty = new BigDecimal(filter.getMinQty()).stripTrailingZeros();
                    maxQty = new BigDecimal(filter.getMaxQty()).stripTrailingZeros();
                    stepSize = new BigDecimal(filter.getStepSize()).stripTrailingZeros();
                    continue;
                }
                if (!filter.getFilterType().equals("MIN_NOTIONAL")) continue;
                counterMinQty = new BigDecimal(filter.getMinNotional()).stripTrailingZeros();
            }
            boolean marketOrderAllowed = Arrays.asList(symbol.getOrderTypes()).contains("MARKET");
            currencyPairs.put(currentCurrencyPair, new CurrencyPairMetaData(new BigDecimal("0.1"), minQty, maxQty, counterMinQty, counterMaxQty, amountPrecision, pairPrecision, null, null, stepSize, null, marketOrderAllowed));
            Currency baseCurrency = currentCurrencyPair.base;
            CurrencyMetaData baseCurrencyMetaData = BinanceAdapters.adaptCurrencyMetaData(currencies, baseCurrency, assetDetailMap, basePrecision);
            currencies.put(baseCurrency, baseCurrencyMetaData);
            Currency counterCurrency = currentCurrencyPair.counter;
            CurrencyMetaData counterCurrencyMetaData = BinanceAdapters.adaptCurrencyMetaData(currencies, counterCurrency, assetDetailMap, counterPrecision);
            currencies.put(counterCurrency, counterCurrencyMetaData);
        }
    }

    private boolean isAuthenticated() {
        return this.exchangeSpecification != null && this.exchangeSpecification.getApiKey() != null && this.exchangeSpecification.getSecretKey() != null;
    }

    private int numberOfDecimals(String value) {
        return new BigDecimal(value).stripTrailingZeros().scale();
    }

    private static void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null && BinanceExchange.enabledSandbox(exchangeSpecification)) {
            exchangeSpecification.setSslUri("https://testnet.binance.vision");
            exchangeSpecification.setHost("testnet.binance.vision");
        }
    }

    private static boolean enabledSandbox(ExchangeSpecification exchangeSpecification) {
        return Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox"));
    }
}

